/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class ClientboundRemoveEntitiesPacket
implements Packet {
    @Nonnull
    private final int[] entityIds;

    public ClientboundRemoveEntitiesPacket(NetInput in) throws IOException {
        this.entityIds = new int[in.readVarInt()];
        for (int i = 0; i < this.entityIds.length; ++i) {
            this.entityIds[i] = in.readVarInt();
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityIds.length);
        for (int entityId : this.entityIds) {
            out.writeVarInt(entityId);
        }
    }

    @Nonnull
    public int[] getEntityIds() {
        return this.entityIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRemoveEntitiesPacket)) {
            return false;
        }
        ClientboundRemoveEntitiesPacket other = (ClientboundRemoveEntitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getEntityIds(), other.getEntityIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRemoveEntitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getEntityIds());
        return result;
    }

    public String toString() {
        return "ClientboundRemoveEntitiesPacket(entityIds=" + Arrays.toString(this.getEntityIds()) + ")";
    }

    public ClientboundRemoveEntitiesPacket withEntityIds(@Nonnull int[] entityIds) {
        if (entityIds == null) {
            throw new NullPointerException("entityIds is marked non-null but is null");
        }
        return this.entityIds == entityIds ? this : new ClientboundRemoveEntitiesPacket(entityIds);
    }

    public ClientboundRemoveEntitiesPacket(@Nonnull int[] entityIds) {
        if (entityIds == null) {
            throw new NullPointerException("entityIds is marked non-null but is null");
        }
        this.entityIds = entityIds;
    }
}

