/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.EntityEvent;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundEntityEventPacket
implements Packet {
    private final int entityId;
    @NonNull
    private final EntityEvent status;

    public ClientboundEntityEventPacket(NetInput in) throws IOException {
        this.entityId = in.readInt();
        this.status = MagicValues.key(EntityEvent.class, in.readByte());
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(this.entityId);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.status).intValue());
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public EntityEvent getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundEntityEventPacket)) {
            return false;
        }
        ClientboundEntityEventPacket other = (ClientboundEntityEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        EntityEvent this$status = this.getStatus();
        EntityEvent other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundEntityEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        EntityEvent $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundEntityEventPacket(entityId=" + this.getEntityId() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public ClientboundEntityEventPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundEntityEventPacket(entityId, this.status);
    }

    public ClientboundEntityEventPacket withStatus(@NonNull EntityEvent status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return this.status == status ? this : new ClientboundEntityEventPacket(this.entityId, status);
    }

    public ClientboundEntityEventPacket(int entityId, @NonNull EntityEvent status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.entityId = entityId;
        this.status = status;
    }
}

