/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.data.game.recipe.Recipe;
import com.github.steveice10.mc.protocol.data.game.recipe.RecipeType;
import com.github.steveice10.mc.protocol.data.game.recipe.data.CookedRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.RecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapedRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapelessRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.SmithingRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.StoneCuttingRecipeData;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundUpdateRecipesPacket
implements Packet {
    @NonNull
    private final Recipe[] recipes;

    public ClientboundUpdateRecipesPacket(NetInput in) throws IOException {
        this.recipes = new Recipe[in.readVarInt()];
        for (int i = 0; i < this.recipes.length; ++i) {
            RecipeType type = MagicValues.key(RecipeType.class, Identifier.formalize(in.readString()));
            String identifier = in.readString();
            RecipeData data = null;
            switch (type) {
                case CRAFTING_SHAPELESS: {
                    String group = in.readString();
                    Ingredient[] ingredients = new Ingredient[in.readVarInt()];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = this.readIngredient(in);
                    }
                    ItemStack result = ItemStack.read(in);
                    data = new ShapelessRecipeData(group, ingredients, result);
                    break;
                }
                case CRAFTING_SHAPED: {
                    int width = in.readVarInt();
                    int height = in.readVarInt();
                    String group = in.readString();
                    Ingredient[] ingredients = new Ingredient[width * height];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = this.readIngredient(in);
                    }
                    ItemStack result = ItemStack.read(in);
                    data = new ShapedRecipeData(width, height, group, ingredients, result);
                    break;
                }
                case SMELTING: 
                case BLASTING: 
                case SMOKING: 
                case CAMPFIRE_COOKING: {
                    String group = in.readString();
                    Ingredient ingredient = this.readIngredient(in);
                    ItemStack result = ItemStack.read(in);
                    float experience = in.readFloat();
                    int cookingTime = in.readVarInt();
                    data = new CookedRecipeData(group, ingredient, result, experience, cookingTime);
                    break;
                }
                case STONECUTTING: {
                    String group = in.readString();
                    Ingredient ingredient = this.readIngredient(in);
                    ItemStack result = ItemStack.read(in);
                    data = new StoneCuttingRecipeData(group, ingredient, result);
                    break;
                }
                case SMITHING: {
                    Ingredient base = this.readIngredient(in);
                    Ingredient addition = this.readIngredient(in);
                    ItemStack result = ItemStack.read(in);
                    data = new SmithingRecipeData(base, addition, result);
                    break;
                }
            }
            this.recipes[i] = new Recipe(type, identifier, data);
        }
    }

    private Ingredient readIngredient(NetInput in) throws IOException {
        ItemStack[] options = new ItemStack[in.readVarInt()];
        for (int i = 0; i < options.length; ++i) {
            options[i] = ItemStack.read(in);
        }
        return new Ingredient(options);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.recipes.length);
        block7: for (Recipe recipe : this.recipes) {
            out.writeString(MagicValues.value(String.class, (Object)recipe.getType()));
            out.writeString(recipe.getIdentifier());
            switch (recipe.getType()) {
                case CRAFTING_SHAPELESS: {
                    RecipeData data = (ShapelessRecipeData)recipe.getData();
                    out.writeString(((ShapelessRecipeData)data).getGroup());
                    out.writeVarInt(((ShapelessRecipeData)data).getIngredients().length);
                    for (Ingredient ingredient : ((ShapelessRecipeData)data).getIngredients()) {
                        this.writeIngredient(out, ingredient);
                    }
                    ItemStack.write(out, ((ShapelessRecipeData)data).getResult());
                    continue block7;
                }
                case CRAFTING_SHAPED: {
                    RecipeData data = (ShapedRecipeData)recipe.getData();
                    if (((ShapedRecipeData)data).getIngredients().length != ((ShapedRecipeData)data).getWidth() * ((ShapedRecipeData)data).getHeight()) {
                        throw new IllegalStateException("Shaped recipe must have ingredient count equal to width * height.");
                    }
                    out.writeVarInt(((ShapedRecipeData)data).getWidth());
                    out.writeVarInt(((ShapedRecipeData)data).getHeight());
                    out.writeString(((ShapedRecipeData)data).getGroup());
                    for (Ingredient ingredient : ((ShapedRecipeData)data).getIngredients()) {
                        this.writeIngredient(out, ingredient);
                    }
                    ItemStack.write(out, ((ShapedRecipeData)data).getResult());
                    continue block7;
                }
                case SMELTING: 
                case BLASTING: 
                case SMOKING: 
                case CAMPFIRE_COOKING: {
                    RecipeData data = (CookedRecipeData)recipe.getData();
                    out.writeString(((CookedRecipeData)data).getGroup());
                    this.writeIngredient(out, ((CookedRecipeData)data).getIngredient());
                    ItemStack.write(out, ((CookedRecipeData)data).getResult());
                    out.writeFloat(((CookedRecipeData)data).getExperience());
                    out.writeVarInt(((CookedRecipeData)data).getCookingTime());
                    continue block7;
                }
                case STONECUTTING: {
                    RecipeData data = (StoneCuttingRecipeData)recipe.getData();
                    out.writeString(((StoneCuttingRecipeData)data).getGroup());
                    this.writeIngredient(out, ((StoneCuttingRecipeData)data).getIngredient());
                    ItemStack.write(out, ((StoneCuttingRecipeData)data).getResult());
                    continue block7;
                }
                case SMITHING: {
                    RecipeData data = (SmithingRecipeData)recipe.getData();
                    this.writeIngredient(out, ((SmithingRecipeData)data).getBase());
                    this.writeIngredient(out, ((SmithingRecipeData)data).getAddition());
                    ItemStack.write(out, ((SmithingRecipeData)data).getResult());
                    continue block7;
                }
            }
        }
    }

    private void writeIngredient(NetOutput out, Ingredient ingredient) throws IOException {
        out.writeVarInt(ingredient.getOptions().length);
        for (ItemStack option : ingredient.getOptions()) {
            ItemStack.write(out, option);
        }
    }

    @NonNull
    public Recipe[] getRecipes() {
        return this.recipes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateRecipesPacket)) {
            return false;
        }
        ClientboundUpdateRecipesPacket other = (ClientboundUpdateRecipesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getRecipes(), other.getRecipes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateRecipesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getRecipes());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateRecipesPacket(recipes=" + Arrays.deepToString(this.getRecipes()) + ")";
    }

    public ClientboundUpdateRecipesPacket withRecipes(@NonNull Recipe[] recipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        return this.recipes == recipes ? this : new ClientboundUpdateRecipesPacket(recipes);
    }

    public ClientboundUpdateRecipesPacket(@NonNull Recipe[] recipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        this.recipes = recipes;
    }
}

