/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.github.steveice10.mc.protocol.data.game.statistic.BreakBlockStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.BreakItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.CraftItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.CustomStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.DropItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.KillEntityStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.KilledByEntityStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.PickupItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.Statistic;
import com.github.steveice10.mc.protocol.data.game.statistic.StatisticCategory;
import com.github.steveice10.mc.protocol.data.game.statistic.UseItemStatistic;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class ClientboundAwardStatsPacket
implements Packet {
    @NonNull
    private final Map<Statistic, Integer> statistics = new HashMap<Statistic, Integer>();

    public ClientboundAwardStatsPacket(NetInput in) throws IOException {
        int length = in.readVarInt();
        for (int index = 0; index < length; ++index) {
            Statistic statistic;
            StatisticCategory category = StatisticCategory.read(in);
            int statisticId = in.readVarInt();
            switch (category) {
                case BREAK_BLOCK: {
                    statistic = new BreakBlockStatistic(statisticId);
                    break;
                }
                case CRAFT_ITEM: {
                    statistic = new CraftItemStatistic(statisticId);
                    break;
                }
                case USE_ITEM: {
                    statistic = new UseItemStatistic(statisticId);
                    break;
                }
                case BREAK_ITEM: {
                    statistic = new BreakItemStatistic(statisticId);
                    break;
                }
                case PICKED_UP_ITEM: {
                    statistic = new PickupItemStatistic(statisticId);
                    break;
                }
                case DROP_ITEM: {
                    statistic = new DropItemStatistic(statisticId);
                    break;
                }
                case KILL_ENTITY: {
                    statistic = new KillEntityStatistic(EntityType.fromId(statisticId));
                    break;
                }
                case KILLED_BY_ENTITY: {
                    statistic = new KilledByEntityStatistic(EntityType.fromId(statisticId));
                    break;
                }
                case CUSTOM: {
                    statistic = CustomStatistic.fromId(statisticId);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.statistics.put(statistic, in.readVarInt());
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.statistics.size());
        for (Map.Entry<Statistic, Integer> entry : this.statistics.entrySet()) {
            int statisticId;
            StatisticCategory category;
            Statistic statistic = entry.getKey();
            if (statistic instanceof BreakBlockStatistic) {
                category = StatisticCategory.BREAK_BLOCK;
                statisticId = ((BreakBlockStatistic)statistic).getId();
            } else if (statistic instanceof CraftItemStatistic) {
                category = StatisticCategory.CRAFT_ITEM;
                statisticId = ((CraftItemStatistic)statistic).getId();
            } else if (statistic instanceof UseItemStatistic) {
                category = StatisticCategory.USE_ITEM;
                statisticId = ((UseItemStatistic)statistic).getId();
            } else if (statistic instanceof BreakItemStatistic) {
                category = StatisticCategory.BREAK_ITEM;
                statisticId = ((BreakItemStatistic)statistic).getId();
            } else if (statistic instanceof PickupItemStatistic) {
                category = StatisticCategory.PICKED_UP_ITEM;
                statisticId = ((PickupItemStatistic)statistic).getId();
            } else if (statistic instanceof DropItemStatistic) {
                category = StatisticCategory.DROP_ITEM;
                statisticId = ((DropItemStatistic)statistic).getId();
            } else if (statistic instanceof KillEntityStatistic) {
                category = StatisticCategory.KILL_ENTITY;
                statisticId = ((KillEntityStatistic)statistic).getEntity().ordinal();
            } else if (statistic instanceof KilledByEntityStatistic) {
                category = StatisticCategory.KILLED_BY_ENTITY;
                statisticId = ((KilledByEntityStatistic)statistic).getEntity().ordinal();
            } else if (statistic instanceof CustomStatistic) {
                category = StatisticCategory.CUSTOM;
                statisticId = ((CustomStatistic)statistic).ordinal();
            } else {
                throw new IllegalStateException();
            }
            out.writeVarInt(category.ordinal());
            out.writeVarInt(statisticId);
            out.writeVarInt(entry.getValue().intValue());
        }
    }

    @NonNull
    public Map<Statistic, Integer> getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAwardStatsPacket)) {
            return false;
        }
        ClientboundAwardStatsPacket other = (ClientboundAwardStatsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Statistic, Integer> this$statistics = this.getStatistics();
        Map<Statistic, Integer> other$statistics = other.getStatistics();
        return !(this$statistics == null ? other$statistics != null : !((Object)this$statistics).equals(other$statistics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAwardStatsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Statistic, Integer> $statistics = this.getStatistics();
        result = result * 59 + ($statistics == null ? 43 : ((Object)$statistics).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundAwardStatsPacket(statistics=" + this.getStatistics() + ")";
    }

    public ClientboundAwardStatsPacket() {
    }
}

