/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.MetadataType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import lombok.NonNull;

public abstract class EntityMetadata<V, T extends MetadataType<V>> {
    protected final int id;
    @NonNull
    protected final T type;

    public abstract V getValue();

    public static EntityMetadata<?, ?>[] read(NetInput in) throws IOException {
        int id;
        ArrayList ret = new ArrayList();
        while ((id = in.readUnsignedByte()) != 255) {
            MetadataType<?> type = MetadataType.read(in);
            ret.add(type.readMetadata(in, id));
        }
        return ret.toArray(new EntityMetadata[0]);
    }

    protected void write(NetOutput out) throws IOException {
        ((MetadataType)this.type).writeMetadata(out, this.getValue());
    }

    public static void write(NetOutput out, EntityMetadata<?, ?>[] metadata) throws IOException {
        for (EntityMetadata<?, ?> meta : metadata) {
            out.writeByte(meta.getId());
            MetadataType.write(out, meta.getType());
            meta.write(out);
        }
        out.writeByte(255);
    }

    public String toString() {
        return "EntityMetadata(id=" + this.id + ", type=" + this.type + ", value=" + this.getValue().toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityMetadata)) {
            return false;
        }
        EntityMetadata that = (EntityMetadata)o;
        return this.id == that.id && this.type == that.type && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.getValue());
    }

    public int getId() {
        return this.id;
    }

    @NonNull
    public T getType() {
        return this.type;
    }

    public EntityMetadata(int id, @NonNull T type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
    }
}

