/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.attribute;

import com.github.steveice10.mc.protocol.data.game.entity.attribute.ModifierOperation;
import java.util.UUID;
import lombok.NonNull;

public class AttributeModifier {
    @NonNull
    private final UUID uuid;
    private final double amount;
    @NonNull
    private final ModifierOperation operation;

    public AttributeModifier(@NonNull UUID uuid, double amount, @NonNull ModifierOperation operation) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.uuid = uuid;
        this.amount = amount;
        this.operation = operation;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    public double getAmount() {
        return this.amount;
    }

    @NonNull
    public ModifierOperation getOperation() {
        return this.operation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeModifier)) {
            return false;
        }
        AttributeModifier other = (AttributeModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        ModifierOperation this$operation = this.getOperation();
        ModifierOperation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        ModifierOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    public String toString() {
        return "AttributeModifier(uuid=" + this.getUuid() + ", amount=" + this.getAmount() + ", operation=" + (Object)((Object)this.getOperation()) + ")";
    }
}

