/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.VPNEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "server", "user", "group", "password", "key", "type"})
public class VPN {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="server")
    @JsonPropertyDescription(value="VPN. Server. URI\r\nurn:x-oca:ocpp:uid:1:569272\r\nVPN Server Address\r\n")
    @Size(max=512)
    @NotNull
    private @Size(max=512) @NotNull String server;
    @JsonProperty(value="user")
    @JsonPropertyDescription(value="VPN. User. User_ Name\r\nurn:x-oca:ocpp:uid:1:569273\r\nVPN User\r\n")
    @Size(max=20)
    @NotNull
    private @Size(max=20) @NotNull String user;
    @JsonProperty(value="group")
    @JsonPropertyDescription(value="VPN. Group. Group_ Name\r\nurn:x-oca:ocpp:uid:1:569274\r\nVPN group.\r\n")
    @Size(max=20)
    private @Size(max=20) String group;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="VPN. Password. Password\r\nurn:x-oca:ocpp:uid:1:569275\r\nVPN Password.\r\n")
    @Size(max=20)
    @NotNull
    private @Size(max=20) @NotNull String password;
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="VPN. Key. VPN_ Key\r\nurn:x-oca:ocpp:uid:1:569276\r\nVPN shared secret.\r\n")
    @Size(max=255)
    @NotNull
    private @Size(max=255) @NotNull String key;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="VPN. Type. VPN_ Code\r\nurn:x-oca:ocpp:uid:1:569277\r\nType of VPN\r\n")
    @NotNull
    private VPNEnum type;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public VPN withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="server")
    public String getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServer(String server) {
        this.server = server;
    }

    public VPN withServer(String server) {
        this.server = server;
        return this;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    public void setUser(String user) {
        this.user = user;
    }

    public VPN withUser(String user) {
        this.user = user;
        return this;
    }

    @JsonProperty(value="group")
    public String getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    public void setGroup(String group) {
        this.group = group;
    }

    public VPN withGroup(String group) {
        this.group = group;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public VPN withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public VPN withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty(value="type")
    public VPNEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(VPNEnum type) {
        this.type = type;
    }

    public VPN withType(VPNEnum type) {
        this.type = type;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VPN.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("server");
        sb.append('=');
        sb.append(this.server == null ? "<null>" : this.server);
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(this.user == null ? "<null>" : this.user);
        sb.append(',');
        sb.append("group");
        sb.append('=');
        sb.append(this.group == null ? "<null>" : this.group);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(this.key == null ? "<null>" : this.key);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.server == null ? 0 : this.server.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + (this.key == null ? 0 : this.key.hashCode());
        result = result * 31 + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof VPN)) {
            return false;
        }
        VPN rhs = (VPN)other;
        return (this.server == rhs.server || this.server != null && this.server.equals(rhs.server)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.user == rhs.user || this.user != null && this.user.equals(rhs.user)) && (this.key == rhs.key || this.key != null && this.key.equals(rhs.key)) && (this.group == rhs.group || this.group != null && this.group.equals(rhs.group));
    }
}

