/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.EVSE;
import ocpp._2020._03.IdToken;
import ocpp._2020._03.MeterValue;
import ocpp._2020._03.Transaction;
import ocpp._2020._03.TransactionEventEnum;
import ocpp._2020._03.TriggerReasonEnum;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "eventType", "meterValue", "timestamp", "triggerReason", "seqNo", "offline", "numberOfPhasesUsed", "cableMaxCurrent", "reservationId", "transactionInfo", "evse", "idToken"})
public class TransactionEventRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="eventType")
    @JsonPropertyDescription(value="This contains the type of this event.\r\nThe first TransactionEvent of a transaction SHALL contain: \"Started\" The last TransactionEvent of a transaction SHALL contain: \"Ended\" All others SHALL contain: \"Updated\"\r\n")
    @NotNull
    private TransactionEventEnum eventType;
    @JsonProperty(value="meterValue")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<MeterValue> meterValue = new ArrayList<MeterValue>();
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="The date and time at which this transaction event occurred.\r\n")
    @NotNull
    private DateTime timestamp;
    @JsonProperty(value="triggerReason")
    @JsonPropertyDescription(value="Reason the Charging Station sends this message to the CSMS\r\n")
    @NotNull
    private TriggerReasonEnum triggerReason;
    @JsonProperty(value="seqNo")
    @JsonPropertyDescription(value="Incremental sequence number, helps with determining if all messages of a transaction have been received.\r\n")
    @NotNull
    private Integer seqNo;
    @JsonProperty(value="offline")
    @JsonPropertyDescription(value="Indication that this transaction event happened when the Charging Station was offline. Default = false, meaning: the event occurred when the Charging Station was online.\r\n")
    private Boolean offline = false;
    @JsonProperty(value="numberOfPhasesUsed")
    @JsonPropertyDescription(value="If the Charging Station is able to report the number of phases used, then it SHALL provide it. When omitted the CSMS may be able to determine the number of phases used via device management.\r\n")
    private Integer numberOfPhasesUsed;
    @JsonProperty(value="cableMaxCurrent")
    @JsonPropertyDescription(value="The maximum current of the connected cable in Ampere (A).\r\n")
    private Integer cableMaxCurrent;
    @JsonProperty(value="reservationId")
    @JsonPropertyDescription(value="This contains the Id of the reservation that terminates as a result of this transaction.\r\n")
    private Integer reservationId;
    @JsonProperty(value="transactionInfo")
    @JsonPropertyDescription(value="Transaction\r\nurn:x-oca:ocpp:uid:2:233318\r\n")
    @Valid
    @NotNull
    private Transaction transactionInfo;
    @JsonProperty(value="evse")
    @JsonPropertyDescription(value="EVSE\r\nurn:x-oca:ocpp:uid:2:233123\r\nElectric Vehicle Supply Equipment\r\n")
    @Valid
    private EVSE evse;
    @JsonProperty(value="idToken")
    @JsonPropertyDescription(value="Contains a case insensitive identifier to use for the authorization and the type of authorization to support multiple forms of identifiers.\r\n")
    @Valid
    private IdToken idToken;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public TransactionEventRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="eventType")
    public TransactionEventEnum getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    public void setEventType(TransactionEventEnum eventType) {
        this.eventType = eventType;
    }

    public TransactionEventRequest withEventType(TransactionEventEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @JsonProperty(value="meterValue")
    public List<MeterValue> getMeterValue() {
        return this.meterValue;
    }

    @JsonProperty(value="meterValue")
    public void setMeterValue(List<MeterValue> meterValue) {
        this.meterValue = meterValue;
    }

    public TransactionEventRequest withMeterValue(List<MeterValue> meterValue) {
        this.meterValue = meterValue;
        return this;
    }

    @JsonProperty(value="timestamp")
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
    }

    public TransactionEventRequest withTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="triggerReason")
    public TriggerReasonEnum getTriggerReason() {
        return this.triggerReason;
    }

    @JsonProperty(value="triggerReason")
    public void setTriggerReason(TriggerReasonEnum triggerReason) {
        this.triggerReason = triggerReason;
    }

    public TransactionEventRequest withTriggerReason(TriggerReasonEnum triggerReason) {
        this.triggerReason = triggerReason;
        return this;
    }

    @JsonProperty(value="seqNo")
    public Integer getSeqNo() {
        return this.seqNo;
    }

    @JsonProperty(value="seqNo")
    public void setSeqNo(Integer seqNo) {
        this.seqNo = seqNo;
    }

    public TransactionEventRequest withSeqNo(Integer seqNo) {
        this.seqNo = seqNo;
        return this;
    }

    @JsonProperty(value="offline")
    public Boolean getOffline() {
        return this.offline;
    }

    @JsonProperty(value="offline")
    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    public TransactionEventRequest withOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    @JsonProperty(value="numberOfPhasesUsed")
    public Integer getNumberOfPhasesUsed() {
        return this.numberOfPhasesUsed;
    }

    @JsonProperty(value="numberOfPhasesUsed")
    public void setNumberOfPhasesUsed(Integer numberOfPhasesUsed) {
        this.numberOfPhasesUsed = numberOfPhasesUsed;
    }

    public TransactionEventRequest withNumberOfPhasesUsed(Integer numberOfPhasesUsed) {
        this.numberOfPhasesUsed = numberOfPhasesUsed;
        return this;
    }

    @JsonProperty(value="cableMaxCurrent")
    public Integer getCableMaxCurrent() {
        return this.cableMaxCurrent;
    }

    @JsonProperty(value="cableMaxCurrent")
    public void setCableMaxCurrent(Integer cableMaxCurrent) {
        this.cableMaxCurrent = cableMaxCurrent;
    }

    public TransactionEventRequest withCableMaxCurrent(Integer cableMaxCurrent) {
        this.cableMaxCurrent = cableMaxCurrent;
        return this;
    }

    @JsonProperty(value="reservationId")
    public Integer getReservationId() {
        return this.reservationId;
    }

    @JsonProperty(value="reservationId")
    public void setReservationId(Integer reservationId) {
        this.reservationId = reservationId;
    }

    public TransactionEventRequest withReservationId(Integer reservationId) {
        this.reservationId = reservationId;
        return this;
    }

    @JsonProperty(value="transactionInfo")
    public Transaction getTransactionInfo() {
        return this.transactionInfo;
    }

    @JsonProperty(value="transactionInfo")
    public void setTransactionInfo(Transaction transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    public TransactionEventRequest withTransactionInfo(Transaction transactionInfo) {
        this.transactionInfo = transactionInfo;
        return this;
    }

    @JsonProperty(value="evse")
    public EVSE getEvse() {
        return this.evse;
    }

    @JsonProperty(value="evse")
    public void setEvse(EVSE evse) {
        this.evse = evse;
    }

    public TransactionEventRequest withEvse(EVSE evse) {
        this.evse = evse;
        return this;
    }

    @JsonProperty(value="idToken")
    public IdToken getIdToken() {
        return this.idToken;
    }

    @JsonProperty(value="idToken")
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    public TransactionEventRequest withIdToken(IdToken idToken) {
        this.idToken = idToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TransactionEventRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(this.eventType == null ? "<null>" : this.eventType);
        sb.append(',');
        sb.append("meterValue");
        sb.append('=');
        sb.append(this.meterValue == null ? "<null>" : this.meterValue);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append((Object)(this.timestamp == null ? "<null>" : this.timestamp));
        sb.append(',');
        sb.append("triggerReason");
        sb.append('=');
        sb.append(this.triggerReason == null ? "<null>" : this.triggerReason);
        sb.append(',');
        sb.append("seqNo");
        sb.append('=');
        sb.append(this.seqNo == null ? "<null>" : this.seqNo);
        sb.append(',');
        sb.append("offline");
        sb.append('=');
        sb.append(this.offline == null ? "<null>" : this.offline);
        sb.append(',');
        sb.append("numberOfPhasesUsed");
        sb.append('=');
        sb.append(this.numberOfPhasesUsed == null ? "<null>" : this.numberOfPhasesUsed);
        sb.append(',');
        sb.append("cableMaxCurrent");
        sb.append('=');
        sb.append(this.cableMaxCurrent == null ? "<null>" : this.cableMaxCurrent);
        sb.append(',');
        sb.append("reservationId");
        sb.append('=');
        sb.append(this.reservationId == null ? "<null>" : this.reservationId);
        sb.append(',');
        sb.append("transactionInfo");
        sb.append('=');
        sb.append(this.transactionInfo == null ? "<null>" : this.transactionInfo);
        sb.append(',');
        sb.append("evse");
        sb.append('=');
        sb.append(this.evse == null ? "<null>" : this.evse);
        sb.append(',');
        sb.append("idToken");
        sb.append('=');
        sb.append(this.idToken == null ? "<null>" : this.idToken);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.seqNo == null ? 0 : this.seqNo.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = result * 31 + (this.evse == null ? 0 : this.evse.hashCode());
        result = result * 31 + (this.transactionInfo == null ? 0 : this.transactionInfo.hashCode());
        result = result * 31 + (this.offline == null ? 0 : this.offline.hashCode());
        result = result * 31 + (this.reservationId == null ? 0 : this.reservationId.hashCode());
        result = result * 31 + (this.triggerReason == null ? 0 : this.triggerReason.hashCode());
        result = result * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
        result = result * 31 + (this.meterValue == null ? 0 : this.meterValue.hashCode());
        result = result * 31 + (this.cableMaxCurrent == null ? 0 : this.cableMaxCurrent.hashCode());
        result = result * 31 + (this.numberOfPhasesUsed == null ? 0 : this.numberOfPhasesUsed.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TransactionEventRequest)) {
            return false;
        }
        TransactionEventRequest rhs = (TransactionEventRequest)other;
        return (this.seqNo == rhs.seqNo || this.seqNo != null && this.seqNo.equals(rhs.seqNo)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.eventType == rhs.eventType || this.eventType != null && this.eventType.equals((Object)rhs.eventType)) && (this.evse == rhs.evse || this.evse != null && this.evse.equals(rhs.evse)) && (this.transactionInfo == rhs.transactionInfo || this.transactionInfo != null && this.transactionInfo.equals(rhs.transactionInfo)) && (this.offline == rhs.offline || this.offline != null && this.offline.equals(rhs.offline)) && (this.reservationId == rhs.reservationId || this.reservationId != null && this.reservationId.equals(rhs.reservationId)) && (this.triggerReason == rhs.triggerReason || this.triggerReason != null && this.triggerReason.equals((Object)rhs.triggerReason)) && (this.idToken == rhs.idToken || this.idToken != null && this.idToken.equals(rhs.idToken)) && (this.meterValue == rhs.meterValue || this.meterValue != null && this.meterValue.equals(rhs.meterValue)) && (this.cableMaxCurrent == rhs.cableMaxCurrent || this.cableMaxCurrent != null && this.cableMaxCurrent.equals(rhs.cableMaxCurrent)) && (this.numberOfPhasesUsed == rhs.numberOfPhasesUsed || this.numberOfPhasesUsed != null && this.numberOfPhasesUsed.equals(rhs.numberOfPhasesUsed)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals((Object)rhs.timestamp));
    }
}

