/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import ocpp._2020._03.CertificateSigningUseEnum;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "csr", "certificateType"})
public class SignCertificateRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="csr")
    @JsonPropertyDescription(value="The Charging Station SHALL send the public key in form of a Certificate Signing Request (CSR) as described in RFC 2986 [22] and then PEM encoded, using the &lt;&lt;signcertificaterequest,SignCertificateRequest&gt;&gt; message.\r\n")
    @Size(max=5500)
    @NotNull
    private @Size(max=5500) @NotNull String csr;
    @JsonProperty(value="certificateType")
    @JsonPropertyDescription(value="Indicates the type of certificate that is to be signed. When omitted the certificate is to be used for both the 15118 connection (if implemented) and the Charging Station to CSMS connection.\r\n\r\n")
    private CertificateSigningUseEnum certificateType;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SignCertificateRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="csr")
    public String getCsr() {
        return this.csr;
    }

    @JsonProperty(value="csr")
    public void setCsr(String csr) {
        this.csr = csr;
    }

    public SignCertificateRequest withCsr(String csr) {
        this.csr = csr;
        return this;
    }

    @JsonProperty(value="certificateType")
    public CertificateSigningUseEnum getCertificateType() {
        return this.certificateType;
    }

    @JsonProperty(value="certificateType")
    public void setCertificateType(CertificateSigningUseEnum certificateType) {
        this.certificateType = certificateType;
    }

    public SignCertificateRequest withCertificateType(CertificateSigningUseEnum certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SignCertificateRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("csr");
        sb.append('=');
        sb.append(this.csr == null ? "<null>" : this.csr);
        sb.append(',');
        sb.append("certificateType");
        sb.append('=');
        sb.append(this.certificateType == null ? "<null>" : this.certificateType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.csr == null ? 0 : this.csr.hashCode());
        result = result * 31 + (this.certificateType == null ? 0 : this.certificateType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SignCertificateRequest)) {
            return false;
        }
        SignCertificateRequest rhs = (SignCertificateRequest)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.csr == rhs.csr || this.csr != null && this.csr.equals(rhs.csr)) && (this.certificateType == rhs.certificateType || this.certificateType != null && this.certificateType.equals((Object)rhs.certificateType));
    }
}

