/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import ocpp._2020._03.ChargingLimitSourceEnum;
import ocpp._2020._03.ChargingProfile;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "requestId", "chargingLimitSource", "chargingProfile", "tbc", "evseId"})
public class ReportChargingProfilesRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="requestId")
    @JsonPropertyDescription(value="Id used to match the &lt;&lt;getchargingprofilesrequest, GetChargingProfilesRequest&gt;&gt; message with the resulting ReportChargingProfilesRequest messages. When the CSMS provided a requestId in the &lt;&lt;getchargingprofilesrequest, GetChargingProfilesRequest&gt;&gt;, this field SHALL contain the same value.\r\n")
    @NotNull
    private Integer requestId;
    @JsonProperty(value="chargingLimitSource")
    @JsonPropertyDescription(value="Source that has installed this charging profile.\r\n")
    @NotNull
    private ChargingLimitSourceEnum chargingLimitSource;
    @JsonProperty(value="chargingProfile")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ChargingProfile> chargingProfile = new ArrayList<ChargingProfile>();
    @JsonProperty(value="tbc")
    @JsonPropertyDescription(value="To Be Continued. Default value when omitted: false. false indicates that there are no further messages as part of this report.\r\n")
    private Boolean tbc = false;
    @JsonProperty(value="evseId")
    @JsonPropertyDescription(value="The evse to which the charging profile applies. If evseId = 0, the message contains an overall limit for the Charging Station.\r\n")
    @NotNull
    private Integer evseId;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ReportChargingProfilesRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="requestId")
    public Integer getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="requestId")
    public void setRequestId(Integer requestId) {
        this.requestId = requestId;
    }

    public ReportChargingProfilesRequest withRequestId(Integer requestId) {
        this.requestId = requestId;
        return this;
    }

    @JsonProperty(value="chargingLimitSource")
    public ChargingLimitSourceEnum getChargingLimitSource() {
        return this.chargingLimitSource;
    }

    @JsonProperty(value="chargingLimitSource")
    public void setChargingLimitSource(ChargingLimitSourceEnum chargingLimitSource) {
        this.chargingLimitSource = chargingLimitSource;
    }

    public ReportChargingProfilesRequest withChargingLimitSource(ChargingLimitSourceEnum chargingLimitSource) {
        this.chargingLimitSource = chargingLimitSource;
        return this;
    }

    @JsonProperty(value="chargingProfile")
    public List<ChargingProfile> getChargingProfile() {
        return this.chargingProfile;
    }

    @JsonProperty(value="chargingProfile")
    public void setChargingProfile(List<ChargingProfile> chargingProfile) {
        this.chargingProfile = chargingProfile;
    }

    public ReportChargingProfilesRequest withChargingProfile(List<ChargingProfile> chargingProfile) {
        this.chargingProfile = chargingProfile;
        return this;
    }

    @JsonProperty(value="tbc")
    public Boolean getTbc() {
        return this.tbc;
    }

    @JsonProperty(value="tbc")
    public void setTbc(Boolean tbc) {
        this.tbc = tbc;
    }

    public ReportChargingProfilesRequest withTbc(Boolean tbc) {
        this.tbc = tbc;
        return this;
    }

    @JsonProperty(value="evseId")
    public Integer getEvseId() {
        return this.evseId;
    }

    @JsonProperty(value="evseId")
    public void setEvseId(Integer evseId) {
        this.evseId = evseId;
    }

    public ReportChargingProfilesRequest withEvseId(Integer evseId) {
        this.evseId = evseId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReportChargingProfilesRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("requestId");
        sb.append('=');
        sb.append(this.requestId == null ? "<null>" : this.requestId);
        sb.append(',');
        sb.append("chargingLimitSource");
        sb.append('=');
        sb.append(this.chargingLimitSource == null ? "<null>" : this.chargingLimitSource);
        sb.append(',');
        sb.append("chargingProfile");
        sb.append('=');
        sb.append(this.chargingProfile == null ? "<null>" : this.chargingProfile);
        sb.append(',');
        sb.append("tbc");
        sb.append('=');
        sb.append(this.tbc == null ? "<null>" : this.tbc);
        sb.append(',');
        sb.append("evseId");
        sb.append('=');
        sb.append(this.evseId == null ? "<null>" : this.evseId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.evseId == null ? 0 : this.evseId.hashCode());
        result = result * 31 + (this.tbc == null ? 0 : this.tbc.hashCode());
        result = result * 31 + (this.requestId == null ? 0 : this.requestId.hashCode());
        result = result * 31 + (this.chargingProfile == null ? 0 : this.chargingProfile.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.chargingLimitSource == null ? 0 : this.chargingLimitSource.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReportChargingProfilesRequest)) {
            return false;
        }
        ReportChargingProfilesRequest rhs = (ReportChargingProfilesRequest)other;
        return (this.evseId == rhs.evseId || this.evseId != null && this.evseId.equals(rhs.evseId)) && (this.tbc == rhs.tbc || this.tbc != null && this.tbc.equals(rhs.tbc)) && (this.requestId == rhs.requestId || this.requestId != null && this.requestId.equals(rhs.requestId)) && (this.chargingProfile == rhs.chargingProfile || this.chargingProfile != null && this.chargingProfile.equals(rhs.chargingProfile)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.chargingLimitSource == rhs.chargingLimitSource || this.chargingLimitSource != null && this.chargingLimitSource.equals((Object)rhs.chargingLimitSource));
    }
}

