/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.ReportData;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "requestId", "generatedAt", "reportData", "tbc", "seqNo"})
public class NotifyReportRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="requestId")
    @JsonPropertyDescription(value="The id of the GetReportRequest  or GetBaseReportRequest that requested this report\r\n")
    @NotNull
    private Integer requestId;
    @JsonProperty(value="generatedAt")
    @JsonPropertyDescription(value="Timestamp of the moment this message was generated at the Charging Station.\r\n")
    @NotNull
    private DateTime generatedAt;
    @JsonProperty(value="reportData")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<ReportData> reportData = new ArrayList<ReportData>();
    @JsonProperty(value="tbc")
    @JsonPropertyDescription(value="\u201cto be continued\u201d indicator. Indicates whether another part of the report follows in an upcoming notifyReportRequest message. Default value when omitted is false.\r\n\r\n")
    private Boolean tbc = false;
    @JsonProperty(value="seqNo")
    @JsonPropertyDescription(value="Sequence number of this message. First message starts at 0.\r\n")
    @NotNull
    private Integer seqNo;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public NotifyReportRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="requestId")
    public Integer getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="requestId")
    public void setRequestId(Integer requestId) {
        this.requestId = requestId;
    }

    public NotifyReportRequest withRequestId(Integer requestId) {
        this.requestId = requestId;
        return this;
    }

    @JsonProperty(value="generatedAt")
    public DateTime getGeneratedAt() {
        return this.generatedAt;
    }

    @JsonProperty(value="generatedAt")
    public void setGeneratedAt(DateTime generatedAt) {
        this.generatedAt = generatedAt;
    }

    public NotifyReportRequest withGeneratedAt(DateTime generatedAt) {
        this.generatedAt = generatedAt;
        return this;
    }

    @JsonProperty(value="reportData")
    public List<ReportData> getReportData() {
        return this.reportData;
    }

    @JsonProperty(value="reportData")
    public void setReportData(List<ReportData> reportData) {
        this.reportData = reportData;
    }

    public NotifyReportRequest withReportData(List<ReportData> reportData) {
        this.reportData = reportData;
        return this;
    }

    @JsonProperty(value="tbc")
    public Boolean getTbc() {
        return this.tbc;
    }

    @JsonProperty(value="tbc")
    public void setTbc(Boolean tbc) {
        this.tbc = tbc;
    }

    public NotifyReportRequest withTbc(Boolean tbc) {
        this.tbc = tbc;
        return this;
    }

    @JsonProperty(value="seqNo")
    public Integer getSeqNo() {
        return this.seqNo;
    }

    @JsonProperty(value="seqNo")
    public void setSeqNo(Integer seqNo) {
        this.seqNo = seqNo;
    }

    public NotifyReportRequest withSeqNo(Integer seqNo) {
        this.seqNo = seqNo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NotifyReportRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("requestId");
        sb.append('=');
        sb.append(this.requestId == null ? "<null>" : this.requestId);
        sb.append(',');
        sb.append("generatedAt");
        sb.append('=');
        sb.append((Object)(this.generatedAt == null ? "<null>" : this.generatedAt));
        sb.append(',');
        sb.append("reportData");
        sb.append('=');
        sb.append(this.reportData == null ? "<null>" : this.reportData);
        sb.append(',');
        sb.append("tbc");
        sb.append('=');
        sb.append(this.tbc == null ? "<null>" : this.tbc);
        sb.append(',');
        sb.append("seqNo");
        sb.append('=');
        sb.append(this.seqNo == null ? "<null>" : this.seqNo);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.tbc == null ? 0 : this.tbc.hashCode());
        result = result * 31 + (this.seqNo == null ? 0 : this.seqNo.hashCode());
        result = result * 31 + (this.requestId == null ? 0 : this.requestId.hashCode());
        result = result * 31 + (this.generatedAt == null ? 0 : this.generatedAt.hashCode());
        result = result * 31 + (this.reportData == null ? 0 : this.reportData.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NotifyReportRequest)) {
            return false;
        }
        NotifyReportRequest rhs = (NotifyReportRequest)other;
        return (this.tbc == rhs.tbc || this.tbc != null && this.tbc.equals(rhs.tbc)) && (this.seqNo == rhs.seqNo || this.seqNo != null && this.seqNo.equals(rhs.seqNo)) && (this.requestId == rhs.requestId || this.requestId != null && this.requestId.equals(rhs.requestId)) && (this.generatedAt == rhs.generatedAt || this.generatedAt != null && this.generatedAt.equals((Object)rhs.generatedAt)) && (this.reportData == rhs.reportData || this.reportData != null && this.reportData.equals(rhs.reportData)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData));
    }
}

