/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MessageFormatEnum {
    ASCII("ASCII"),
    HTML("HTML"),
    URI("URI"),
    UTF_8("UTF8");

    private final String value;
    private static final Map<String, MessageFormatEnum> CONSTANTS;

    private MessageFormatEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MessageFormatEnum fromValue(String value) {
        MessageFormatEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MessageFormatEnum>();
        for (MessageFormatEnum c : MessageFormatEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

