/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.MessageFormatEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "format", "language", "content"})
public class MessageContent {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="format")
    @JsonPropertyDescription(value="Message_ Content. Format. Message_ Format_ Code\r\nurn:x-enexis:ecdm:uid:1:570848\r\nFormat of the message.\r\n")
    @NotNull
    private MessageFormatEnum format;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="Message_ Content. Language. Language_ Code\r\nurn:x-enexis:ecdm:uid:1:570849\r\nMessage language identifier. Contains a language code as defined in &lt;&lt;ref-RFC5646,[RFC5646]&gt;&gt;.\r\n")
    @Size(max=8)
    private @Size(max=8) String language;
    @JsonProperty(value="content")
    @JsonPropertyDescription(value="Message_ Content. Content. Message\r\nurn:x-enexis:ecdm:uid:1:570852\r\nMessage contents.\r\n\r\n")
    @Size(max=512)
    @NotNull
    private @Size(max=512) @NotNull String content;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public MessageContent withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="format")
    public MessageFormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    public void setFormat(MessageFormatEnum format) {
        this.format = format;
    }

    public MessageContent withFormat(MessageFormatEnum format) {
        this.format = format;
        return this;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public MessageContent withLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    public void setContent(String content) {
        this.content = content;
    }

    public MessageContent withContent(String content) {
        this.content = content;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageContent.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("format");
        sb.append('=');
        sb.append(this.format == null ? "<null>" : this.format);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("content");
        sb.append('=');
        sb.append(this.content == null ? "<null>" : this.content);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.format == null ? 0 : this.format.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MessageContent)) {
            return false;
        }
        MessageContent rhs = (MessageContent)other;
        return (this.format == rhs.format || this.format != null && this.format.equals((Object)rhs.format)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.content == rhs.content || this.content != null && this.content.equals(rhs.content));
    }
}

