/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum HashAlgorithmEnum {
    SHA_256("SHA256"),
    SHA_384("SHA384"),
    SHA_512("SHA512");

    private final String value;
    private static final Map<String, HashAlgorithmEnum> CONSTANTS;

    private HashAlgorithmEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static HashAlgorithmEnum fromValue(String value) {
        HashAlgorithmEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, HashAlgorithmEnum>();
        for (HashAlgorithmEnum c : HashAlgorithmEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

