/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import ocpp._2020._03.ChargingProfileCriterion;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "requestId", "evseId", "chargingProfile"})
public class GetChargingProfilesRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="requestId")
    @JsonPropertyDescription(value="Reference identification that is to be used by the Charging Station in the &lt;&lt;reportchargingprofilesrequest, ReportChargingProfilesRequest&gt;&gt; when provided.\r\n")
    @NotNull
    private Integer requestId;
    @JsonProperty(value="evseId")
    @JsonPropertyDescription(value="For which EVSE installed charging profiles SHALL be reported. If 0, only charging profiles installed on the Charging Station itself (the grid connection) SHALL be reported. If omitted, all installed charging profiles SHALL be reported.\r\n")
    private Integer evseId;
    @JsonProperty(value="chargingProfile")
    @JsonPropertyDescription(value="Charging_ Profile\r\nurn:x-oca:ocpp:uid:2:233255\r\nA ChargingProfile consists of ChargingSchedule, describing the amount of power or current that can be delivered per time interval.\r\n")
    @Valid
    @NotNull
    private ChargingProfileCriterion chargingProfile;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public GetChargingProfilesRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="requestId")
    public Integer getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="requestId")
    public void setRequestId(Integer requestId) {
        this.requestId = requestId;
    }

    public GetChargingProfilesRequest withRequestId(Integer requestId) {
        this.requestId = requestId;
        return this;
    }

    @JsonProperty(value="evseId")
    public Integer getEvseId() {
        return this.evseId;
    }

    @JsonProperty(value="evseId")
    public void setEvseId(Integer evseId) {
        this.evseId = evseId;
    }

    public GetChargingProfilesRequest withEvseId(Integer evseId) {
        this.evseId = evseId;
        return this;
    }

    @JsonProperty(value="chargingProfile")
    public ChargingProfileCriterion getChargingProfile() {
        return this.chargingProfile;
    }

    @JsonProperty(value="chargingProfile")
    public void setChargingProfile(ChargingProfileCriterion chargingProfile) {
        this.chargingProfile = chargingProfile;
    }

    public GetChargingProfilesRequest withChargingProfile(ChargingProfileCriterion chargingProfile) {
        this.chargingProfile = chargingProfile;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GetChargingProfilesRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("requestId");
        sb.append('=');
        sb.append(this.requestId == null ? "<null>" : this.requestId);
        sb.append(',');
        sb.append("evseId");
        sb.append('=');
        sb.append(this.evseId == null ? "<null>" : this.evseId);
        sb.append(',');
        sb.append("chargingProfile");
        sb.append('=');
        sb.append(this.chargingProfile == null ? "<null>" : this.chargingProfile);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.evseId == null ? 0 : this.evseId.hashCode());
        result = result * 31 + (this.chargingProfile == null ? 0 : this.chargingProfile.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.requestId == null ? 0 : this.requestId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GetChargingProfilesRequest)) {
            return false;
        }
        GetChargingProfilesRequest rhs = (GetChargingProfilesRequest)other;
        return (this.evseId == rhs.evseId || this.evseId != null && this.evseId.equals(rhs.evseId)) && (this.chargingProfile == rhs.chargingProfile || this.chargingProfile != null && this.chargingProfile.equals(rhs.chargingProfile)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.requestId == rhs.requestId || this.requestId != null && this.requestId.equals(rhs.requestId));
    }
}

