/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import ocpp._2020._03.CertificateActionEnum;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "iso15118SchemaVersion", "action", "exiRequest"})
public class Get15118EVCertificateRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="iso15118SchemaVersion")
    @JsonPropertyDescription(value="Schema version currently used for the 15118 session between EV and Charging Station. Needed for parsing of the EXI stream by the CSMS.\r\n\r\n")
    @Size(max=50)
    @NotNull
    private @Size(max=50) @NotNull String iso15118SchemaVersion;
    @JsonProperty(value="action")
    @JsonPropertyDescription(value="Defines whether certificate needs to be installed or updated.\r\n")
    @NotNull
    private CertificateActionEnum action;
    @JsonProperty(value="exiRequest")
    @JsonPropertyDescription(value="Raw CertificateInstallationReq request from EV, Base64 encoded.\r\n")
    @Size(max=5600)
    @NotNull
    private @Size(max=5600) @NotNull String exiRequest;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public Get15118EVCertificateRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="iso15118SchemaVersion")
    public String getIso15118SchemaVersion() {
        return this.iso15118SchemaVersion;
    }

    @JsonProperty(value="iso15118SchemaVersion")
    public void setIso15118SchemaVersion(String iso15118SchemaVersion) {
        this.iso15118SchemaVersion = iso15118SchemaVersion;
    }

    public Get15118EVCertificateRequest withIso15118SchemaVersion(String iso15118SchemaVersion) {
        this.iso15118SchemaVersion = iso15118SchemaVersion;
        return this;
    }

    @JsonProperty(value="action")
    public CertificateActionEnum getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    public void setAction(CertificateActionEnum action) {
        this.action = action;
    }

    public Get15118EVCertificateRequest withAction(CertificateActionEnum action) {
        this.action = action;
        return this;
    }

    @JsonProperty(value="exiRequest")
    public String getExiRequest() {
        return this.exiRequest;
    }

    @JsonProperty(value="exiRequest")
    public void setExiRequest(String exiRequest) {
        this.exiRequest = exiRequest;
    }

    public Get15118EVCertificateRequest withExiRequest(String exiRequest) {
        this.exiRequest = exiRequest;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Get15118EVCertificateRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("iso15118SchemaVersion");
        sb.append('=');
        sb.append(this.iso15118SchemaVersion == null ? "<null>" : this.iso15118SchemaVersion);
        sb.append(',');
        sb.append("action");
        sb.append('=');
        sb.append(this.action == null ? "<null>" : this.action);
        sb.append(',');
        sb.append("exiRequest");
        sb.append('=');
        sb.append(this.exiRequest == null ? "<null>" : this.exiRequest);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.iso15118SchemaVersion == null ? 0 : this.iso15118SchemaVersion.hashCode());
        result = result * 31 + (this.action == null ? 0 : this.action.hashCode());
        result = result * 31 + (this.exiRequest == null ? 0 : this.exiRequest.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Get15118EVCertificateRequest)) {
            return false;
        }
        Get15118EVCertificateRequest rhs = (Get15118EVCertificateRequest)other;
        return (this.iso15118SchemaVersion == rhs.iso15118SchemaVersion || this.iso15118SchemaVersion != null && this.iso15118SchemaVersion.equals(rhs.iso15118SchemaVersion)) && (this.action == rhs.action || this.action != null && this.action.equals((Object)rhs.action)) && (this.exiRequest == rhs.exiRequest || this.exiRequest != null && this.exiRequest.equals(rhs.exiRequest)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData));
    }
}

