/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import ocpp._2020._03.CertificateHashData;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.IdToken;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "customerCertificate", "idToken", "requestId", "report", "clear", "customerIdentifier"})
public class CustomerInformationRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="customerCertificate")
    @Valid
    private CertificateHashData customerCertificate;
    @JsonProperty(value="idToken")
    @JsonPropertyDescription(value="Contains a case insensitive identifier to use for the authorization and the type of authorization to support multiple forms of identifiers.\r\n")
    @Valid
    private IdToken idToken;
    @JsonProperty(value="requestId")
    @JsonPropertyDescription(value="The Id of the request.\r\n\r\n")
    @NotNull
    private Integer requestId;
    @JsonProperty(value="report")
    @JsonPropertyDescription(value="Flag indicating whether the Charging Station should return NotifyCustomerInformationRequest messages containing information about the customer referred to.\r\n")
    @NotNull
    private Boolean report;
    @JsonProperty(value="clear")
    @JsonPropertyDescription(value="Flag indicating whether the Charging Station should clear all information about the customer referred to.\r\n")
    @NotNull
    private Boolean clear;
    @JsonProperty(value="customerIdentifier")
    @JsonPropertyDescription(value="A (e.g. vendor specific) identifier of the customer this request refers to. This field contains a custom identifier other than IdToken and Certificate.\r\nOne of the possible identifiers (customerIdentifier, customerIdToken or customerCertificate) should be in the request message.\r\n")
    @Size(max=64)
    private @Size(max=64) String customerIdentifier;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public CustomerInformationRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="customerCertificate")
    public CertificateHashData getCustomerCertificate() {
        return this.customerCertificate;
    }

    @JsonProperty(value="customerCertificate")
    public void setCustomerCertificate(CertificateHashData customerCertificate) {
        this.customerCertificate = customerCertificate;
    }

    public CustomerInformationRequest withCustomerCertificate(CertificateHashData customerCertificate) {
        this.customerCertificate = customerCertificate;
        return this;
    }

    @JsonProperty(value="idToken")
    public IdToken getIdToken() {
        return this.idToken;
    }

    @JsonProperty(value="idToken")
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    public CustomerInformationRequest withIdToken(IdToken idToken) {
        this.idToken = idToken;
        return this;
    }

    @JsonProperty(value="requestId")
    public Integer getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="requestId")
    public void setRequestId(Integer requestId) {
        this.requestId = requestId;
    }

    public CustomerInformationRequest withRequestId(Integer requestId) {
        this.requestId = requestId;
        return this;
    }

    @JsonProperty(value="report")
    public Boolean getReport() {
        return this.report;
    }

    @JsonProperty(value="report")
    public void setReport(Boolean report) {
        this.report = report;
    }

    public CustomerInformationRequest withReport(Boolean report) {
        this.report = report;
        return this;
    }

    @JsonProperty(value="clear")
    public Boolean getClear() {
        return this.clear;
    }

    @JsonProperty(value="clear")
    public void setClear(Boolean clear) {
        this.clear = clear;
    }

    public CustomerInformationRequest withClear(Boolean clear) {
        this.clear = clear;
        return this;
    }

    @JsonProperty(value="customerIdentifier")
    public String getCustomerIdentifier() {
        return this.customerIdentifier;
    }

    @JsonProperty(value="customerIdentifier")
    public void setCustomerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
    }

    public CustomerInformationRequest withCustomerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomerInformationRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("customerCertificate");
        sb.append('=');
        sb.append(this.customerCertificate == null ? "<null>" : this.customerCertificate);
        sb.append(',');
        sb.append("idToken");
        sb.append('=');
        sb.append(this.idToken == null ? "<null>" : this.idToken);
        sb.append(',');
        sb.append("requestId");
        sb.append('=');
        sb.append(this.requestId == null ? "<null>" : this.requestId);
        sb.append(',');
        sb.append("report");
        sb.append('=');
        sb.append(this.report == null ? "<null>" : this.report);
        sb.append(',');
        sb.append("clear");
        sb.append('=');
        sb.append(this.clear == null ? "<null>" : this.clear);
        sb.append(',');
        sb.append("customerIdentifier");
        sb.append('=');
        sb.append(this.customerIdentifier == null ? "<null>" : this.customerIdentifier);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customerCertificate == null ? 0 : this.customerCertificate.hashCode());
        result = result * 31 + (this.requestId == null ? 0 : this.requestId.hashCode());
        result = result * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
        result = result * 31 + (this.report == null ? 0 : this.report.hashCode());
        result = result * 31 + (this.clear == null ? 0 : this.clear.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.customerIdentifier == null ? 0 : this.customerIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CustomerInformationRequest)) {
            return false;
        }
        CustomerInformationRequest rhs = (CustomerInformationRequest)other;
        return (this.customerCertificate == rhs.customerCertificate || this.customerCertificate != null && this.customerCertificate.equals(rhs.customerCertificate)) && (this.requestId == rhs.requestId || this.requestId != null && this.requestId.equals(rhs.requestId)) && (this.idToken == rhs.idToken || this.idToken != null && this.idToken.equals(rhs.idToken)) && (this.report == rhs.report || this.report != null && this.report.equals(rhs.report)) && (this.clear == rhs.clear || this.clear != null && this.clear.equals(rhs.clear)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.customerIdentifier == rhs.customerIdentifier || this.customerIdentifier != null && this.customerIdentifier.equals(rhs.customerIdentifier));
    }
}

