/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import ocpp._2020._03.Cost;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "startValue", "cost"})
public class ConsumptionCost {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="startValue")
    @JsonPropertyDescription(value="Consumption_ Cost. Start_ Value. Numeric\r\nurn:x-oca:ocpp:uid:1:569246\r\nThe lowest level of consumption that defines the starting point of this consumption block. The block interval extends to the start of the next interval.\r\n")
    @NotNull
    private Double startValue;
    @JsonProperty(value="cost")
    @Size(min=1, max=3)
    @Valid
    @NotNull
    private @Size(min=1, max=3) @Valid @NotNull List<Cost> cost = new ArrayList<Cost>();

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ConsumptionCost withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="startValue")
    public Double getStartValue() {
        return this.startValue;
    }

    @JsonProperty(value="startValue")
    public void setStartValue(Double startValue) {
        this.startValue = startValue;
    }

    public ConsumptionCost withStartValue(Double startValue) {
        this.startValue = startValue;
        return this;
    }

    @JsonProperty(value="cost")
    public List<Cost> getCost() {
        return this.cost;
    }

    @JsonProperty(value="cost")
    public void setCost(List<Cost> cost) {
        this.cost = cost;
    }

    public ConsumptionCost withCost(List<Cost> cost) {
        this.cost = cost;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ConsumptionCost.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("startValue");
        sb.append('=');
        sb.append(this.startValue == null ? "<null>" : this.startValue);
        sb.append(',');
        sb.append("cost");
        sb.append('=');
        sb.append(this.cost == null ? "<null>" : this.cost);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.startValue == null ? 0 : this.startValue.hashCode());
        result = result * 31 + (this.cost == null ? 0 : this.cost.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ConsumptionCost)) {
            return false;
        }
        ConsumptionCost rhs = (ConsumptionCost)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.startValue == rhs.startValue || this.startValue != null && this.startValue.equals(rhs.startValue)) && (this.cost == rhs.cost || this.cost != null && this.cost.equals(rhs.cost));
    }
}

