/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.EVSE;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "evse", "name", "instance"})
public class Component {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="evse")
    @JsonPropertyDescription(value="EVSE\r\nurn:x-oca:ocpp:uid:2:233123\r\nElectric Vehicle Supply Equipment\r\n")
    @Valid
    private EVSE evse;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the component. Name should be taken from the list of standardized component names whenever possible. Case Insensitive. strongly advised to use Camel Case.\r\n")
    @Size(max=50)
    @NotNull
    private @Size(max=50) @NotNull String name;
    @JsonProperty(value="instance")
    @JsonPropertyDescription(value="Name of instance in case the component exists as multiple instances. Case Insensitive. strongly advised to use Camel Case.\r\n")
    @Size(max=50)
    private @Size(max=50) String instance;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public Component withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="evse")
    public EVSE getEvse() {
        return this.evse;
    }

    @JsonProperty(value="evse")
    public void setEvse(EVSE evse) {
        this.evse = evse;
    }

    public Component withEvse(EVSE evse) {
        this.evse = evse;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Component withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    @JsonProperty(value="instance")
    public void setInstance(String instance) {
        this.instance = instance;
    }

    public Component withInstance(String instance) {
        this.instance = instance;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Component.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("evse");
        sb.append('=');
        sb.append(this.evse == null ? "<null>" : this.evse);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("instance");
        sb.append('=');
        sb.append(this.instance == null ? "<null>" : this.instance);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.instance == null ? 0 : this.instance.hashCode());
        result = result * 31 + (this.evse == null ? 0 : this.evse.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Component)) {
            return false;
        }
        Component rhs = (Component)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.instance == rhs.instance || this.instance != null && this.instance.equals(rhs.instance)) && (this.evse == rhs.evse || this.evse != null && this.evse.equals(rhs.evse));
    }
}

