/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import ocpp._2020._03.CertificateHashData;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.GetCertificateIdUseEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "certificateHashData", "certificateType", "childCertificateHashData"})
public class CertificateHashDataChain {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="certificateHashData")
    @Valid
    @NotNull
    private CertificateHashData certificateHashData;
    @JsonProperty(value="certificateType")
    @JsonPropertyDescription(value="Indicates the type of the requested certificate(s).\r\n")
    @NotNull
    private GetCertificateIdUseEnum certificateType;
    @JsonProperty(value="childCertificateHashData")
    @Size(min=1, max=4)
    @Valid
    private @Size(min=1, max=4) @Valid List<CertificateHashData> childCertificateHashData = new ArrayList<CertificateHashData>();

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public CertificateHashDataChain withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="certificateHashData")
    public CertificateHashData getCertificateHashData() {
        return this.certificateHashData;
    }

    @JsonProperty(value="certificateHashData")
    public void setCertificateHashData(CertificateHashData certificateHashData) {
        this.certificateHashData = certificateHashData;
    }

    public CertificateHashDataChain withCertificateHashData(CertificateHashData certificateHashData) {
        this.certificateHashData = certificateHashData;
        return this;
    }

    @JsonProperty(value="certificateType")
    public GetCertificateIdUseEnum getCertificateType() {
        return this.certificateType;
    }

    @JsonProperty(value="certificateType")
    public void setCertificateType(GetCertificateIdUseEnum certificateType) {
        this.certificateType = certificateType;
    }

    public CertificateHashDataChain withCertificateType(GetCertificateIdUseEnum certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    @JsonProperty(value="childCertificateHashData")
    public List<CertificateHashData> getChildCertificateHashData() {
        return this.childCertificateHashData;
    }

    @JsonProperty(value="childCertificateHashData")
    public void setChildCertificateHashData(List<CertificateHashData> childCertificateHashData) {
        this.childCertificateHashData = childCertificateHashData;
    }

    public CertificateHashDataChain withChildCertificateHashData(List<CertificateHashData> childCertificateHashData) {
        this.childCertificateHashData = childCertificateHashData;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CertificateHashDataChain.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("certificateHashData");
        sb.append('=');
        sb.append(this.certificateHashData == null ? "<null>" : this.certificateHashData);
        sb.append(',');
        sb.append("certificateType");
        sb.append('=');
        sb.append(this.certificateType == null ? "<null>" : this.certificateType);
        sb.append(',');
        sb.append("childCertificateHashData");
        sb.append('=');
        sb.append(this.childCertificateHashData == null ? "<null>" : this.childCertificateHashData);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.childCertificateHashData == null ? 0 : this.childCertificateHashData.hashCode());
        result = result * 31 + (this.certificateHashData == null ? 0 : this.certificateHashData.hashCode());
        result = result * 31 + (this.certificateType == null ? 0 : this.certificateType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CertificateHashDataChain)) {
            return false;
        }
        CertificateHashDataChain rhs = (CertificateHashDataChain)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.childCertificateHashData == rhs.childCertificateHashData || this.childCertificateHashData != null && this.childCertificateHashData.equals(rhs.childCertificateHashData)) && (this.certificateHashData == rhs.certificateHashData || this.certificateHashData != null && this.certificateHashData.equals(rhs.certificateHashData)) && (this.certificateType == rhs.certificateType || this.certificateType != null && this.certificateType.equals((Object)rhs.certificateType));
    }
}

