/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.HashAlgorithmEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "hashAlgorithm", "issuerNameHash", "issuerKeyHash", "serialNumber"})
public class CertificateHashData {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="hashAlgorithm")
    @JsonPropertyDescription(value="Used algorithms for the hashes provided.\r\n")
    @NotNull
    private HashAlgorithmEnum hashAlgorithm;
    @JsonProperty(value="issuerNameHash")
    @JsonPropertyDescription(value="Hashed value of the Issuer DN (Distinguished Name).\r\n\r\n")
    @Size(max=128)
    @NotNull
    private @Size(max=128) @NotNull String issuerNameHash;
    @JsonProperty(value="issuerKeyHash")
    @JsonPropertyDescription(value="Hashed value of the issuers public key\r\n")
    @Size(max=128)
    @NotNull
    private @Size(max=128) @NotNull String issuerKeyHash;
    @JsonProperty(value="serialNumber")
    @JsonPropertyDescription(value="The serial number of the certificate.\r\n")
    @Size(max=40)
    @NotNull
    private @Size(max=40) @NotNull String serialNumber;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public CertificateHashData withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="hashAlgorithm")
    public HashAlgorithmEnum getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @JsonProperty(value="hashAlgorithm")
    public void setHashAlgorithm(HashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public CertificateHashData withHashAlgorithm(HashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    @JsonProperty(value="issuerNameHash")
    public String getIssuerNameHash() {
        return this.issuerNameHash;
    }

    @JsonProperty(value="issuerNameHash")
    public void setIssuerNameHash(String issuerNameHash) {
        this.issuerNameHash = issuerNameHash;
    }

    public CertificateHashData withIssuerNameHash(String issuerNameHash) {
        this.issuerNameHash = issuerNameHash;
        return this;
    }

    @JsonProperty(value="issuerKeyHash")
    public String getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    @JsonProperty(value="issuerKeyHash")
    public void setIssuerKeyHash(String issuerKeyHash) {
        this.issuerKeyHash = issuerKeyHash;
    }

    public CertificateHashData withIssuerKeyHash(String issuerKeyHash) {
        this.issuerKeyHash = issuerKeyHash;
        return this;
    }

    @JsonProperty(value="serialNumber")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="serialNumber")
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public CertificateHashData withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CertificateHashData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("hashAlgorithm");
        sb.append('=');
        sb.append(this.hashAlgorithm == null ? "<null>" : this.hashAlgorithm);
        sb.append(',');
        sb.append("issuerNameHash");
        sb.append('=');
        sb.append(this.issuerNameHash == null ? "<null>" : this.issuerNameHash);
        sb.append(',');
        sb.append("issuerKeyHash");
        sb.append('=');
        sb.append(this.issuerKeyHash == null ? "<null>" : this.issuerKeyHash);
        sb.append(',');
        sb.append("serialNumber");
        sb.append('=');
        sb.append(this.serialNumber == null ? "<null>" : this.serialNumber);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.issuerNameHash == null ? 0 : this.issuerNameHash.hashCode());
        result = result * 31 + (this.issuerKeyHash == null ? 0 : this.issuerKeyHash.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = result * 31 + (this.hashAlgorithm == null ? 0 : this.hashAlgorithm.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CertificateHashData)) {
            return false;
        }
        CertificateHashData rhs = (CertificateHashData)other;
        return (this.issuerNameHash == rhs.issuerNameHash || this.issuerNameHash != null && this.issuerNameHash.equals(rhs.issuerNameHash)) && (this.issuerKeyHash == rhs.issuerKeyHash || this.issuerKeyHash != null && this.issuerKeyHash.equals(rhs.issuerKeyHash)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.serialNumber == rhs.serialNumber || this.serialNumber != null && this.serialNumber.equals(rhs.serialNumber)) && (this.hashAlgorithm == rhs.hashAlgorithm || this.hashAlgorithm != null && this.hashAlgorithm.equals((Object)rhs.hashAlgorithm));
    }
}

