/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.IdToken;
import ocpp._2020._03.IdTokenInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "idToken", "idTokenInfo"})
public class AuthorizationData {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="idToken")
    @JsonPropertyDescription(value="Contains a case insensitive identifier to use for the authorization and the type of authorization to support multiple forms of identifiers.\r\n")
    @Valid
    @NotNull
    private IdToken idToken;
    @JsonProperty(value="idTokenInfo")
    @JsonPropertyDescription(value="ID_ Token\r\nurn:x-oca:ocpp:uid:2:233247\r\nContains status information about an identifier.\r\nIt is advised to not stop charging for a token that expires during charging, as ExpiryDate is only used for caching purposes. If ExpiryDate is not given, the status has no end date.\r\n")
    @Valid
    private IdTokenInfo idTokenInfo;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public AuthorizationData withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="idToken")
    public IdToken getIdToken() {
        return this.idToken;
    }

    @JsonProperty(value="idToken")
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    public AuthorizationData withIdToken(IdToken idToken) {
        this.idToken = idToken;
        return this;
    }

    @JsonProperty(value="idTokenInfo")
    public IdTokenInfo getIdTokenInfo() {
        return this.idTokenInfo;
    }

    @JsonProperty(value="idTokenInfo")
    public void setIdTokenInfo(IdTokenInfo idTokenInfo) {
        this.idTokenInfo = idTokenInfo;
    }

    public AuthorizationData withIdTokenInfo(IdTokenInfo idTokenInfo) {
        this.idTokenInfo = idTokenInfo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuthorizationData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("idToken");
        sb.append('=');
        sb.append(this.idToken == null ? "<null>" : this.idToken);
        sb.append(',');
        sb.append("idTokenInfo");
        sb.append('=');
        sb.append(this.idTokenInfo == null ? "<null>" : this.idTokenInfo);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.idTokenInfo == null ? 0 : this.idTokenInfo.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuthorizationData)) {
            return false;
        }
        AuthorizationData rhs = (AuthorizationData)other;
        return (this.idToken == rhs.idToken || this.idToken != null && this.idToken.equals(rhs.idToken)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.idTokenInfo == rhs.idTokenInfo || this.idTokenInfo != null && this.idTokenInfo.equals(rhs.idTokenInfo));
    }
}

