/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "energyAmount", "evMinCurrent", "evMaxCurrent", "evMaxVoltage"})
public class ACChargingParameters {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="energyAmount")
    @JsonPropertyDescription(value="AC_ Charging_ Parameters. Energy_ Amount. Energy_ Amount\r\nurn:x-oca:ocpp:uid:1:569211\r\nAmount of energy requested (in Wh). This includes energy required for preconditioning.\r\n")
    @NotNull
    private Integer energyAmount;
    @JsonProperty(value="evMinCurrent")
    @JsonPropertyDescription(value="AC_ Charging_ Parameters. EV_ Min. Current\r\nurn:x-oca:ocpp:uid:1:569212\r\nMinimum current (amps) supported by the electric vehicle (per phase).\r\n")
    @NotNull
    private Integer evMinCurrent;
    @JsonProperty(value="evMaxCurrent")
    @JsonPropertyDescription(value="AC_ Charging_ Parameters. EV_ Max. Current\r\nurn:x-oca:ocpp:uid:1:569213\r\nMaximum current (amps) supported by the electric vehicle (per phase). Includes cable capacity.\r\n")
    @NotNull
    private Integer evMaxCurrent;
    @JsonProperty(value="evMaxVoltage")
    @JsonPropertyDescription(value="AC_ Charging_ Parameters. EV_ Max. Voltage\r\nurn:x-oca:ocpp:uid:1:569214\r\nMaximum voltage supported by the electric vehicle\r\n")
    @NotNull
    private Integer evMaxVoltage;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ACChargingParameters withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="energyAmount")
    public Integer getEnergyAmount() {
        return this.energyAmount;
    }

    @JsonProperty(value="energyAmount")
    public void setEnergyAmount(Integer energyAmount) {
        this.energyAmount = energyAmount;
    }

    public ACChargingParameters withEnergyAmount(Integer energyAmount) {
        this.energyAmount = energyAmount;
        return this;
    }

    @JsonProperty(value="evMinCurrent")
    public Integer getEvMinCurrent() {
        return this.evMinCurrent;
    }

    @JsonProperty(value="evMinCurrent")
    public void setEvMinCurrent(Integer evMinCurrent) {
        this.evMinCurrent = evMinCurrent;
    }

    public ACChargingParameters withEvMinCurrent(Integer evMinCurrent) {
        this.evMinCurrent = evMinCurrent;
        return this;
    }

    @JsonProperty(value="evMaxCurrent")
    public Integer getEvMaxCurrent() {
        return this.evMaxCurrent;
    }

    @JsonProperty(value="evMaxCurrent")
    public void setEvMaxCurrent(Integer evMaxCurrent) {
        this.evMaxCurrent = evMaxCurrent;
    }

    public ACChargingParameters withEvMaxCurrent(Integer evMaxCurrent) {
        this.evMaxCurrent = evMaxCurrent;
        return this;
    }

    @JsonProperty(value="evMaxVoltage")
    public Integer getEvMaxVoltage() {
        return this.evMaxVoltage;
    }

    @JsonProperty(value="evMaxVoltage")
    public void setEvMaxVoltage(Integer evMaxVoltage) {
        this.evMaxVoltage = evMaxVoltage;
    }

    public ACChargingParameters withEvMaxVoltage(Integer evMaxVoltage) {
        this.evMaxVoltage = evMaxVoltage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ACChargingParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("energyAmount");
        sb.append('=');
        sb.append(this.energyAmount == null ? "<null>" : this.energyAmount);
        sb.append(',');
        sb.append("evMinCurrent");
        sb.append('=');
        sb.append(this.evMinCurrent == null ? "<null>" : this.evMinCurrent);
        sb.append(',');
        sb.append("evMaxCurrent");
        sb.append('=');
        sb.append(this.evMaxCurrent == null ? "<null>" : this.evMaxCurrent);
        sb.append(',');
        sb.append("evMaxVoltage");
        sb.append('=');
        sb.append(this.evMaxVoltage == null ? "<null>" : this.evMaxVoltage);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.energyAmount == null ? 0 : this.energyAmount.hashCode());
        result = result * 31 + (this.evMaxCurrent == null ? 0 : this.evMaxCurrent.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.evMinCurrent == null ? 0 : this.evMinCurrent.hashCode());
        result = result * 31 + (this.evMaxVoltage == null ? 0 : this.evMaxVoltage.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ACChargingParameters)) {
            return false;
        }
        ACChargingParameters rhs = (ACChargingParameters)other;
        return (this.energyAmount == rhs.energyAmount || this.energyAmount != null && this.energyAmount.equals(rhs.energyAmount)) && (this.evMaxCurrent == rhs.evMaxCurrent || this.evMaxCurrent != null && this.evMaxCurrent.equals(rhs.evMaxCurrent)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.evMinCurrent == rhs.evMinCurrent || this.evMinCurrent != null && this.evMinCurrent.equals(rhs.evMinCurrent)) && (this.evMaxVoltage == rhs.evMaxVoltage || this.evMaxVoltage != null && this.evMaxVoltage.equals(rhs.evMaxVoltage));
    }
}

