/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum VPNEnum {
    IK_EV_2("IKEv2"),
    IP_SEC("IPSec"),
    L_2_TP("L2TP"),
    PPTP("PPTP");

    private final String value;
    private static final Map<String, VPNEnum> CONSTANTS;

    private VPNEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static VPNEnum fromValue(String value) {
        VPNEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, VPNEnum>();
        for (VPNEnum c : VPNEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

