/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.Firmware;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "retries", "retryInterval", "requestId", "firmware"})
public class UpdateFirmwareRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="retries")
    @JsonPropertyDescription(value="This specifies how many times Charging Station must try to download the firmware before giving up. If this field is not present, it is left to Charging Station to decide how many times it wants to retry.\r\n")
    private Integer retries;
    @JsonProperty(value="retryInterval")
    @JsonPropertyDescription(value="The interval in seconds after which a retry may be attempted. If this field is not present, it is left to Charging Station to decide how long to wait between attempts.\r\n")
    private Integer retryInterval;
    @JsonProperty(value="requestId")
    @JsonPropertyDescription(value="The Id of this request\r\n")
    @NotNull
    private Integer requestId;
    @JsonProperty(value="firmware")
    @JsonPropertyDescription(value="Firmware\r\nurn:x-enexis:ecdm:uid:2:233291\r\nRepresents a copy of the firmware that can be loaded/updated on the Charging Station.\r\n")
    @Valid
    @NotNull
    private Firmware firmware;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public UpdateFirmwareRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public UpdateFirmwareRequest withRetries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="retryInterval")
    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    @JsonProperty(value="retryInterval")
    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public UpdateFirmwareRequest withRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    @JsonProperty(value="requestId")
    public Integer getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="requestId")
    public void setRequestId(Integer requestId) {
        this.requestId = requestId;
    }

    public UpdateFirmwareRequest withRequestId(Integer requestId) {
        this.requestId = requestId;
        return this;
    }

    @JsonProperty(value="firmware")
    public Firmware getFirmware() {
        return this.firmware;
    }

    @JsonProperty(value="firmware")
    public void setFirmware(Firmware firmware) {
        this.firmware = firmware;
    }

    public UpdateFirmwareRequest withFirmware(Firmware firmware) {
        this.firmware = firmware;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UpdateFirmwareRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("retries");
        sb.append('=');
        sb.append(this.retries == null ? "<null>" : this.retries);
        sb.append(',');
        sb.append("retryInterval");
        sb.append('=');
        sb.append(this.retryInterval == null ? "<null>" : this.retryInterval);
        sb.append(',');
        sb.append("requestId");
        sb.append('=');
        sb.append(this.requestId == null ? "<null>" : this.requestId);
        sb.append(',');
        sb.append("firmware");
        sb.append('=');
        sb.append(this.firmware == null ? "<null>" : this.firmware);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.retries == null ? 0 : this.retries.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.retryInterval == null ? 0 : this.retryInterval.hashCode());
        result = result * 31 + (this.firmware == null ? 0 : this.firmware.hashCode());
        result = result * 31 + (this.requestId == null ? 0 : this.requestId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof UpdateFirmwareRequest)) {
            return false;
        }
        UpdateFirmwareRequest rhs = (UpdateFirmwareRequest)other;
        return (this.retries == rhs.retries || this.retries != null && this.retries.equals(rhs.retries)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.retryInterval == rhs.retryInterval || this.retryInterval != null && this.retryInterval.equals(rhs.retryInterval)) && (this.firmware == rhs.firmware || this.firmware != null && this.firmware.equals(rhs.firmware)) && (this.requestId == rhs.requestId || this.requestId != null && this.requestId.equals(rhs.requestId));
    }
}

