/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ocpp._2020._03.ConsumptionCost;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.RelativeTimeInterval;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "relativeTimeInterval", "ePriceLevel", "consumptionCost"})
public class SalesTariffEntry {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="relativeTimeInterval")
    @JsonPropertyDescription(value="Relative_ Timer_ Interval\r\nurn:x-oca:ocpp:uid:2:233270\r\n")
    @Valid
    @NotNull
    private RelativeTimeInterval relativeTimeInterval;
    @JsonProperty(value="ePriceLevel")
    @JsonPropertyDescription(value="Sales_ Tariff_ Entry. E_ Price_ Level. Unsigned_ Integer\r\nurn:x-oca:ocpp:uid:1:569281\r\nDefines the price level of this SalesTariffEntry (referring to NumEPriceLevels). Small values for the EPriceLevel represent a cheaper TariffEntry. Large values for the EPriceLevel represent a more expensive TariffEntry.\r\n")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer ePriceLevel;
    @JsonProperty(value="consumptionCost")
    @Size(min=1, max=3)
    @Valid
    private @Size(min=1, max=3) @Valid List<ConsumptionCost> consumptionCost = new ArrayList<ConsumptionCost>();

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public SalesTariffEntry withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="relativeTimeInterval")
    public RelativeTimeInterval getRelativeTimeInterval() {
        return this.relativeTimeInterval;
    }

    @JsonProperty(value="relativeTimeInterval")
    public void setRelativeTimeInterval(RelativeTimeInterval relativeTimeInterval) {
        this.relativeTimeInterval = relativeTimeInterval;
    }

    public SalesTariffEntry withRelativeTimeInterval(RelativeTimeInterval relativeTimeInterval) {
        this.relativeTimeInterval = relativeTimeInterval;
        return this;
    }

    @JsonProperty(value="ePriceLevel")
    public Integer getePriceLevel() {
        return this.ePriceLevel;
    }

    @JsonProperty(value="ePriceLevel")
    public void setePriceLevel(Integer ePriceLevel) {
        this.ePriceLevel = ePriceLevel;
    }

    public SalesTariffEntry withePriceLevel(Integer ePriceLevel) {
        this.ePriceLevel = ePriceLevel;
        return this;
    }

    @JsonProperty(value="consumptionCost")
    public List<ConsumptionCost> getConsumptionCost() {
        return this.consumptionCost;
    }

    @JsonProperty(value="consumptionCost")
    public void setConsumptionCost(List<ConsumptionCost> consumptionCost) {
        this.consumptionCost = consumptionCost;
    }

    public SalesTariffEntry withConsumptionCost(List<ConsumptionCost> consumptionCost) {
        this.consumptionCost = consumptionCost;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SalesTariffEntry.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("relativeTimeInterval");
        sb.append('=');
        sb.append(this.relativeTimeInterval == null ? "<null>" : this.relativeTimeInterval);
        sb.append(',');
        sb.append("ePriceLevel");
        sb.append('=');
        sb.append(this.ePriceLevel == null ? "<null>" : this.ePriceLevel);
        sb.append(',');
        sb.append("consumptionCost");
        sb.append('=');
        sb.append(this.consumptionCost == null ? "<null>" : this.consumptionCost);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.consumptionCost == null ? 0 : this.consumptionCost.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.relativeTimeInterval == null ? 0 : this.relativeTimeInterval.hashCode());
        result = result * 31 + (this.ePriceLevel == null ? 0 : this.ePriceLevel.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SalesTariffEntry)) {
            return false;
        }
        SalesTariffEntry rhs = (SalesTariffEntry)other;
        return (this.consumptionCost == rhs.consumptionCost || this.consumptionCost != null && this.consumptionCost.equals(rhs.consumptionCost)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.relativeTimeInterval == rhs.relativeTimeInterval || this.relativeTimeInterval != null && this.relativeTimeInterval.equals(rhs.relativeTimeInterval)) && (this.ePriceLevel == rhs.ePriceLevel || this.ePriceLevel != null && this.ePriceLevel.equals(rhs.ePriceLevel));
    }
}

