/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ocpp._2020._03.Component;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.Variable;
import ocpp._2020._03.VariableAttribute;
import ocpp._2020._03.VariableCharacteristics;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "component", "variable", "variableAttribute", "variableCharacteristics"})
public class ReportData {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="component")
    @JsonPropertyDescription(value="A physical or logical component\r\n")
    @Valid
    @NotNull
    private Component component;
    @JsonProperty(value="variable")
    @JsonPropertyDescription(value="Reference key to a component-variable.\r\n")
    @Valid
    @NotNull
    private Variable variable;
    @JsonProperty(value="variableAttribute")
    @Size(min=1, max=4)
    @Valid
    @NotNull
    private @Size(min=1, max=4) @Valid @NotNull List<VariableAttribute> variableAttribute = new ArrayList<VariableAttribute>();
    @JsonProperty(value="variableCharacteristics")
    @JsonPropertyDescription(value="Fixed read-only parameters of a variable.\r\n")
    @Valid
    private VariableCharacteristics variableCharacteristics;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ReportData withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="component")
    public Component getComponent() {
        return this.component;
    }

    @JsonProperty(value="component")
    public void setComponent(Component component) {
        this.component = component;
    }

    public ReportData withComponent(Component component) {
        this.component = component;
        return this;
    }

    @JsonProperty(value="variable")
    public Variable getVariable() {
        return this.variable;
    }

    @JsonProperty(value="variable")
    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public ReportData withVariable(Variable variable) {
        this.variable = variable;
        return this;
    }

    @JsonProperty(value="variableAttribute")
    public List<VariableAttribute> getVariableAttribute() {
        return this.variableAttribute;
    }

    @JsonProperty(value="variableAttribute")
    public void setVariableAttribute(List<VariableAttribute> variableAttribute) {
        this.variableAttribute = variableAttribute;
    }

    public ReportData withVariableAttribute(List<VariableAttribute> variableAttribute) {
        this.variableAttribute = variableAttribute;
        return this;
    }

    @JsonProperty(value="variableCharacteristics")
    public VariableCharacteristics getVariableCharacteristics() {
        return this.variableCharacteristics;
    }

    @JsonProperty(value="variableCharacteristics")
    public void setVariableCharacteristics(VariableCharacteristics variableCharacteristics) {
        this.variableCharacteristics = variableCharacteristics;
    }

    public ReportData withVariableCharacteristics(VariableCharacteristics variableCharacteristics) {
        this.variableCharacteristics = variableCharacteristics;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReportData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("component");
        sb.append('=');
        sb.append(this.component == null ? "<null>" : this.component);
        sb.append(',');
        sb.append("variable");
        sb.append('=');
        sb.append(this.variable == null ? "<null>" : this.variable);
        sb.append(',');
        sb.append("variableAttribute");
        sb.append('=');
        sb.append(this.variableAttribute == null ? "<null>" : this.variableAttribute);
        sb.append(',');
        sb.append("variableCharacteristics");
        sb.append('=');
        sb.append(this.variableCharacteristics == null ? "<null>" : this.variableCharacteristics);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.variable == null ? 0 : this.variable.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.component == null ? 0 : this.component.hashCode());
        result = result * 31 + (this.variableAttribute == null ? 0 : this.variableAttribute.hashCode());
        result = result * 31 + (this.variableCharacteristics == null ? 0 : this.variableCharacteristics.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReportData)) {
            return false;
        }
        ReportData rhs = (ReportData)other;
        return (this.variable == rhs.variable || this.variable != null && this.variable.equals(rhs.variable)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.component == rhs.component || this.component != null && this.component.equals(rhs.component)) && (this.variableAttribute == rhs.variableAttribute || this.variableAttribute != null && this.variableAttribute.equals(rhs.variableAttribute)) && (this.variableCharacteristics == rhs.variableCharacteristics || this.variableCharacteristics != null && this.variableCharacteristics.equals(rhs.variableCharacteristics));
    }
}

