/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ReasonEnum {
    DE_AUTHORIZED("DeAuthorized"),
    EMERGENCY_STOP("EmergencyStop"),
    ENERGY_LIMIT_REACHED("EnergyLimitReached"),
    EV_DISCONNECTED("EVDisconnected"),
    GROUND_FAULT("GroundFault"),
    IMMEDIATE_RESET("ImmediateReset"),
    LOCAL("Local"),
    LOCAL_OUT_OF_CREDIT("LocalOutOfCredit"),
    MASTER_PASS("MasterPass"),
    OTHER("Other"),
    OVERCURRENT_FAULT("OvercurrentFault"),
    POWER_LOSS("PowerLoss"),
    POWER_QUALITY("PowerQuality"),
    REBOOT("Reboot"),
    REMOTE("Remote"),
    SOC_LIMIT_REACHED("SOCLimitReached"),
    STOPPED_BY_EV("StoppedByEV"),
    TIME_LIMIT_REACHED("TimeLimitReached"),
    TIMEOUT("Timeout");

    private final String value;
    private static final Map<String, ReasonEnum> CONSTANTS;

    private ReasonEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ReasonEnum fromValue(String value) {
        ReasonEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ReasonEnum>();
        for (ReasonEnum c : ReasonEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

