/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ocpp._2020._03.APN;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.OCPPInterfaceEnum;
import ocpp._2020._03.OCPPTransportEnum;
import ocpp._2020._03.OCPPVersionEnum;
import ocpp._2020._03.VPN;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "apn", "ocppVersion", "ocppTransport", "ocppCsmsUrl", "messageTimeout", "securityProfile", "ocppInterface", "vpn"})
public class NetworkConnectionProfile {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="apn")
    @JsonPropertyDescription(value="APN\r\nurn:x-oca:ocpp:uid:2:233134\r\nCollection of configuration data needed to make a data-connection over a cellular network.\r\n\r\nNOTE: When asking a GSM modem to dial in, it is possible to specify which mobile operator should be used. This can be done with the mobile country code (MCC) in combination with a mobile network code (MNC). Example: If your preferred network is Vodafone Netherlands, the MCC=204 and the MNC=04 which means the key PreferredNetwork = 20404 Some modems allows to specify a preferred network, which means, if this network is not available, a different network is used. If you specify UseOnlyPreferredNetwork and this network is not available, the modem will not dial in.\r\n")
    @Valid
    private APN apn;
    @JsonProperty(value="ocppVersion")
    @JsonPropertyDescription(value="Communication_ Function. OCPP_ Version. OCPP_ Version_ Code\r\nurn:x-oca:ocpp:uid:1:569355\r\nDefines the OCPP version used for this communication function.\r\n")
    @NotNull
    private OCPPVersionEnum ocppVersion;
    @JsonProperty(value="ocppTransport")
    @JsonPropertyDescription(value="Communication_ Function. OCPP_ Transport. OCPP_ Transport_ Code\r\nurn:x-oca:ocpp:uid:1:569356\r\nDefines the transport protocol (e.g. SOAP or JSON). Note: SOAP is not supported in OCPP 2.0, but is supported by other versions of OCPP.\r\n")
    @NotNull
    private OCPPTransportEnum ocppTransport;
    @JsonProperty(value="ocppCsmsUrl")
    @JsonPropertyDescription(value="Communication_ Function. OCPP_ Central_ System_ URL. URI\r\nurn:x-oca:ocpp:uid:1:569357\r\nURL of the CSMS(s) that this Charging Station  communicates with.\r\n")
    @Size(max=512)
    @NotNull
    private @Size(max=512) @NotNull String ocppCsmsUrl;
    @JsonProperty(value="messageTimeout")
    @JsonPropertyDescription(value="Duration in seconds before a message send by the Charging Station via this network connection times-out.\r\nThe best setting depends on the underlying network and response times of the CSMS.\r\nIf you are looking for a some guideline: use 30 seconds as a starting point.\r\n")
    @NotNull
    private Integer messageTimeout;
    @JsonProperty(value="securityProfile")
    @JsonPropertyDescription(value="This field specifies the security profile used when connecting to the CSMS with this NetworkConnectionProfile.\r\n")
    @NotNull
    private Integer securityProfile;
    @JsonProperty(value="ocppInterface")
    @JsonPropertyDescription(value="Applicable Network Interface.\r\n")
    @NotNull
    private OCPPInterfaceEnum ocppInterface;
    @JsonProperty(value="vpn")
    @JsonPropertyDescription(value="VPN\r\nurn:x-oca:ocpp:uid:2:233268\r\nVPN Configuration settings\r\n")
    @Valid
    private VPN vpn;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public NetworkConnectionProfile withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="apn")
    public APN getApn() {
        return this.apn;
    }

    @JsonProperty(value="apn")
    public void setApn(APN apn) {
        this.apn = apn;
    }

    public NetworkConnectionProfile withApn(APN apn) {
        this.apn = apn;
        return this;
    }

    @JsonProperty(value="ocppVersion")
    public OCPPVersionEnum getOcppVersion() {
        return this.ocppVersion;
    }

    @JsonProperty(value="ocppVersion")
    public void setOcppVersion(OCPPVersionEnum ocppVersion) {
        this.ocppVersion = ocppVersion;
    }

    public NetworkConnectionProfile withOcppVersion(OCPPVersionEnum ocppVersion) {
        this.ocppVersion = ocppVersion;
        return this;
    }

    @JsonProperty(value="ocppTransport")
    public OCPPTransportEnum getOcppTransport() {
        return this.ocppTransport;
    }

    @JsonProperty(value="ocppTransport")
    public void setOcppTransport(OCPPTransportEnum ocppTransport) {
        this.ocppTransport = ocppTransport;
    }

    public NetworkConnectionProfile withOcppTransport(OCPPTransportEnum ocppTransport) {
        this.ocppTransport = ocppTransport;
        return this;
    }

    @JsonProperty(value="ocppCsmsUrl")
    public String getOcppCsmsUrl() {
        return this.ocppCsmsUrl;
    }

    @JsonProperty(value="ocppCsmsUrl")
    public void setOcppCsmsUrl(String ocppCsmsUrl) {
        this.ocppCsmsUrl = ocppCsmsUrl;
    }

    public NetworkConnectionProfile withOcppCsmsUrl(String ocppCsmsUrl) {
        this.ocppCsmsUrl = ocppCsmsUrl;
        return this;
    }

    @JsonProperty(value="messageTimeout")
    public Integer getMessageTimeout() {
        return this.messageTimeout;
    }

    @JsonProperty(value="messageTimeout")
    public void setMessageTimeout(Integer messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public NetworkConnectionProfile withMessageTimeout(Integer messageTimeout) {
        this.messageTimeout = messageTimeout;
        return this;
    }

    @JsonProperty(value="securityProfile")
    public Integer getSecurityProfile() {
        return this.securityProfile;
    }

    @JsonProperty(value="securityProfile")
    public void setSecurityProfile(Integer securityProfile) {
        this.securityProfile = securityProfile;
    }

    public NetworkConnectionProfile withSecurityProfile(Integer securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    @JsonProperty(value="ocppInterface")
    public OCPPInterfaceEnum getOcppInterface() {
        return this.ocppInterface;
    }

    @JsonProperty(value="ocppInterface")
    public void setOcppInterface(OCPPInterfaceEnum ocppInterface) {
        this.ocppInterface = ocppInterface;
    }

    public NetworkConnectionProfile withOcppInterface(OCPPInterfaceEnum ocppInterface) {
        this.ocppInterface = ocppInterface;
        return this;
    }

    @JsonProperty(value="vpn")
    public VPN getVpn() {
        return this.vpn;
    }

    @JsonProperty(value="vpn")
    public void setVpn(VPN vpn) {
        this.vpn = vpn;
    }

    public NetworkConnectionProfile withVpn(VPN vpn) {
        this.vpn = vpn;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NetworkConnectionProfile.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("apn");
        sb.append('=');
        sb.append(this.apn == null ? "<null>" : this.apn);
        sb.append(',');
        sb.append("ocppVersion");
        sb.append('=');
        sb.append(this.ocppVersion == null ? "<null>" : this.ocppVersion);
        sb.append(',');
        sb.append("ocppTransport");
        sb.append('=');
        sb.append(this.ocppTransport == null ? "<null>" : this.ocppTransport);
        sb.append(',');
        sb.append("ocppCsmsUrl");
        sb.append('=');
        sb.append(this.ocppCsmsUrl == null ? "<null>" : this.ocppCsmsUrl);
        sb.append(',');
        sb.append("messageTimeout");
        sb.append('=');
        sb.append(this.messageTimeout == null ? "<null>" : this.messageTimeout);
        sb.append(',');
        sb.append("securityProfile");
        sb.append('=');
        sb.append(this.securityProfile == null ? "<null>" : this.securityProfile);
        sb.append(',');
        sb.append("ocppInterface");
        sb.append('=');
        sb.append(this.ocppInterface == null ? "<null>" : this.ocppInterface);
        sb.append(',');
        sb.append("vpn");
        sb.append('=');
        sb.append(this.vpn == null ? "<null>" : this.vpn);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.ocppTransport == null ? 0 : this.ocppTransport.hashCode());
        result = result * 31 + (this.securityProfile == null ? 0 : this.securityProfile.hashCode());
        result = result * 31 + (this.vpn == null ? 0 : this.vpn.hashCode());
        result = result * 31 + (this.ocppVersion == null ? 0 : this.ocppVersion.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.ocppCsmsUrl == null ? 0 : this.ocppCsmsUrl.hashCode());
        result = result * 31 + (this.apn == null ? 0 : this.apn.hashCode());
        result = result * 31 + (this.messageTimeout == null ? 0 : this.messageTimeout.hashCode());
        result = result * 31 + (this.ocppInterface == null ? 0 : this.ocppInterface.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NetworkConnectionProfile)) {
            return false;
        }
        NetworkConnectionProfile rhs = (NetworkConnectionProfile)other;
        return (this.ocppTransport == rhs.ocppTransport || this.ocppTransport != null && this.ocppTransport.equals((Object)rhs.ocppTransport)) && (this.securityProfile == rhs.securityProfile || this.securityProfile != null && this.securityProfile.equals(rhs.securityProfile)) && (this.vpn == rhs.vpn || this.vpn != null && this.vpn.equals(rhs.vpn)) && (this.ocppVersion == rhs.ocppVersion || this.ocppVersion != null && this.ocppVersion.equals((Object)rhs.ocppVersion)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.ocppCsmsUrl == rhs.ocppCsmsUrl || this.ocppCsmsUrl != null && this.ocppCsmsUrl.equals(rhs.ocppCsmsUrl)) && (this.apn == rhs.apn || this.apn != null && this.apn.equals(rhs.apn)) && (this.messageTimeout == rhs.messageTimeout || this.messageTimeout != null && this.messageTimeout.equals(rhs.messageTimeout)) && (this.ocppInterface == rhs.ocppInterface || this.ocppInterface != null && this.ocppInterface.equals((Object)rhs.ocppInterface));
    }
}

