/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import ocpp._2020._03.ACChargingParameters;
import ocpp._2020._03.CustomData;
import ocpp._2020._03.DCChargingParameters;
import ocpp._2020._03.EnergyTransferModeEnum;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "acChargingParameters", "dcChargingParameters", "requestedEnergyTransfer", "departureTime"})
public class ChargingNeeds {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="acChargingParameters")
    @JsonPropertyDescription(value="AC_ Charging_ Parameters\r\nurn:x-oca:ocpp:uid:2:233250\r\nEV AC charging parameters.\r\n\r\n")
    @Valid
    private ACChargingParameters acChargingParameters;
    @JsonProperty(value="dcChargingParameters")
    @JsonPropertyDescription(value="DC_ Charging_ Parameters\r\nurn:x-oca:ocpp:uid:2:233251\r\nEV DC charging parameters\r\n\r\n\r\n")
    @Valid
    private DCChargingParameters dcChargingParameters;
    @JsonProperty(value="requestedEnergyTransfer")
    @JsonPropertyDescription(value="Charging_ Needs. Requested. Energy_ Transfer_ Mode_ Code\r\nurn:x-oca:ocpp:uid:1:569209\r\nMode of energy transfer requested by the EV.\r\n")
    @NotNull
    private EnergyTransferModeEnum requestedEnergyTransfer;
    @JsonProperty(value="departureTime")
    @JsonPropertyDescription(value="Charging_ Needs. Departure_ Time. Date_ Time\r\nurn:x-oca:ocpp:uid:1:569223\r\nEstimated departure time of the EV.\r\n")
    private DateTime departureTime;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ChargingNeeds withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="acChargingParameters")
    public ACChargingParameters getAcChargingParameters() {
        return this.acChargingParameters;
    }

    @JsonProperty(value="acChargingParameters")
    public void setAcChargingParameters(ACChargingParameters acChargingParameters) {
        this.acChargingParameters = acChargingParameters;
    }

    public ChargingNeeds withAcChargingParameters(ACChargingParameters acChargingParameters) {
        this.acChargingParameters = acChargingParameters;
        return this;
    }

    @JsonProperty(value="dcChargingParameters")
    public DCChargingParameters getDcChargingParameters() {
        return this.dcChargingParameters;
    }

    @JsonProperty(value="dcChargingParameters")
    public void setDcChargingParameters(DCChargingParameters dcChargingParameters) {
        this.dcChargingParameters = dcChargingParameters;
    }

    public ChargingNeeds withDcChargingParameters(DCChargingParameters dcChargingParameters) {
        this.dcChargingParameters = dcChargingParameters;
        return this;
    }

    @JsonProperty(value="requestedEnergyTransfer")
    public EnergyTransferModeEnum getRequestedEnergyTransfer() {
        return this.requestedEnergyTransfer;
    }

    @JsonProperty(value="requestedEnergyTransfer")
    public void setRequestedEnergyTransfer(EnergyTransferModeEnum requestedEnergyTransfer) {
        this.requestedEnergyTransfer = requestedEnergyTransfer;
    }

    public ChargingNeeds withRequestedEnergyTransfer(EnergyTransferModeEnum requestedEnergyTransfer) {
        this.requestedEnergyTransfer = requestedEnergyTransfer;
        return this;
    }

    @JsonProperty(value="departureTime")
    public DateTime getDepartureTime() {
        return this.departureTime;
    }

    @JsonProperty(value="departureTime")
    public void setDepartureTime(DateTime departureTime) {
        this.departureTime = departureTime;
    }

    public ChargingNeeds withDepartureTime(DateTime departureTime) {
        this.departureTime = departureTime;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ChargingNeeds.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("acChargingParameters");
        sb.append('=');
        sb.append(this.acChargingParameters == null ? "<null>" : this.acChargingParameters);
        sb.append(',');
        sb.append("dcChargingParameters");
        sb.append('=');
        sb.append(this.dcChargingParameters == null ? "<null>" : this.dcChargingParameters);
        sb.append(',');
        sb.append("requestedEnergyTransfer");
        sb.append('=');
        sb.append(this.requestedEnergyTransfer == null ? "<null>" : this.requestedEnergyTransfer);
        sb.append(',');
        sb.append("departureTime");
        sb.append('=');
        sb.append((Object)(this.departureTime == null ? "<null>" : this.departureTime));
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.acChargingParameters == null ? 0 : this.acChargingParameters.hashCode());
        result = result * 31 + (this.dcChargingParameters == null ? 0 : this.dcChargingParameters.hashCode());
        result = result * 31 + (this.departureTime == null ? 0 : this.departureTime.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.requestedEnergyTransfer == null ? 0 : this.requestedEnergyTransfer.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChargingNeeds)) {
            return false;
        }
        ChargingNeeds rhs = (ChargingNeeds)other;
        return (this.acChargingParameters == rhs.acChargingParameters || this.acChargingParameters != null && this.acChargingParameters.equals(rhs.acChargingParameters)) && (this.dcChargingParameters == rhs.dcChargingParameters || this.dcChargingParameters != null && this.dcChargingParameters.equals(rhs.dcChargingParameters)) && (this.departureTime == rhs.departureTime || this.departureTime != null && this.departureTime.equals((Object)rhs.departureTime)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.requestedEnergyTransfer == rhs.requestedEnergyTransfer || this.requestedEnergyTransfer != null && this.requestedEnergyTransfer.equals((Object)rhs.requestedEnergyTransfer));
    }
}

