/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.rwth.idsg.ocpp.jaxb.RequestType;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ocpp._2020._03.CertificateSigningUseEnum;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "certificateChain", "certificateType"})
public class CertificateSignedRequest
implements RequestType {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="certificateChain")
    @JsonPropertyDescription(value="The signed PEM encoded X.509 certificate. This can also contain the necessary sub CA certificates. In that case, the order of the bundle should follow the certificate chain, starting from the leaf certificate.\r\n\r\nThe Configuration Variable &lt;&lt;configkey-max-certificate-chain-size,MaxCertificateChainSize&gt;&gt; can be used to limit the maximum size of this field.\r\n")
    @Size(max=10000)
    @NotNull
    private @Size(max=10000) @NotNull String certificateChain;
    @JsonProperty(value="certificateType")
    @JsonPropertyDescription(value="Indicates the type of the signed certificate that is returned. When omitted the certificate is used for both the 15118 connection (if implemented) and the Charging Station to CSMS connection. This field is required when a typeOfCertificate was included in the &lt;&lt;signcertificaterequest,SignCertificateRequest&gt;&gt; that requested this certificate to be signed AND both the 15118 connection and the Charging Station connection are implemented.\r\n\r\n")
    private CertificateSigningUseEnum certificateType;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public CertificateSignedRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="certificateChain")
    public String getCertificateChain() {
        return this.certificateChain;
    }

    @JsonProperty(value="certificateChain")
    public void setCertificateChain(String certificateChain) {
        this.certificateChain = certificateChain;
    }

    public CertificateSignedRequest withCertificateChain(String certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    @JsonProperty(value="certificateType")
    public CertificateSigningUseEnum getCertificateType() {
        return this.certificateType;
    }

    @JsonProperty(value="certificateType")
    public void setCertificateType(CertificateSigningUseEnum certificateType) {
        this.certificateType = certificateType;
    }

    public CertificateSignedRequest withCertificateType(CertificateSigningUseEnum certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CertificateSignedRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("certificateChain");
        sb.append('=');
        sb.append(this.certificateChain == null ? "<null>" : this.certificateChain);
        sb.append(',');
        sb.append("certificateType");
        sb.append('=');
        sb.append(this.certificateType == null ? "<null>" : this.certificateType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.certificateChain == null ? 0 : this.certificateChain.hashCode());
        result = result * 31 + (this.certificateType == null ? 0 : this.certificateType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CertificateSignedRequest)) {
            return false;
        }
        CertificateSignedRequest rhs = (CertificateSignedRequest)other;
        return (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.certificateChain == rhs.certificateChain || this.certificateChain != null && this.certificateChain.equals(rhs.certificateChain)) && (this.certificateType == rhs.certificateType || this.certificateType != null && this.certificateType.equals((Object)rhs.certificateType));
    }
}

