/*
 * Decompiled with CFR 0.152.
 */
package ocpp._2020._03;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ocpp._2020._03.APNAuthenticationEnum;
import ocpp._2020._03.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "apn", "apnUserName", "apnPassword", "simPin", "preferredNetwork", "useOnlyPreferredNetwork", "apnAuthentication"})
public class APN {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    @Valid
    private CustomData customData;
    @JsonProperty(value="apn")
    @JsonPropertyDescription(value="APN. APN. URI\r\nurn:x-oca:ocpp:uid:1:568814\r\nThe Access Point Name as an URL.\r\n")
    @Size(max=512)
    @NotNull
    private @Size(max=512) @NotNull String apn;
    @JsonProperty(value="apnUserName")
    @JsonPropertyDescription(value="APN. APN. User_ Name\r\nurn:x-oca:ocpp:uid:1:568818\r\nAPN username.\r\n")
    @Size(max=20)
    private @Size(max=20) String apnUserName;
    @JsonProperty(value="apnPassword")
    @JsonPropertyDescription(value="APN. APN. Password\r\nurn:x-oca:ocpp:uid:1:568819\r\nAPN Password.\r\n")
    @Size(max=20)
    private @Size(max=20) String apnPassword;
    @JsonProperty(value="simPin")
    @JsonPropertyDescription(value="APN. SIMPIN. PIN_ Code\r\nurn:x-oca:ocpp:uid:1:568821\r\nSIM card pin code.\r\n")
    private Integer simPin;
    @JsonProperty(value="preferredNetwork")
    @JsonPropertyDescription(value="APN. Preferred_ Network. Mobile_ Network_ ID\r\nurn:x-oca:ocpp:uid:1:568822\r\nPreferred network, written as MCC and MNC concatenated. See note.\r\n")
    @Size(max=6)
    private @Size(max=6) String preferredNetwork;
    @JsonProperty(value="useOnlyPreferredNetwork")
    @JsonPropertyDescription(value="APN. Use_ Only_ Preferred_ Network. Indicator\r\nurn:x-oca:ocpp:uid:1:568824\r\nDefault: false. Use only the preferred Network, do\r\nnot dial in when not available. See Note.\r\n")
    private Boolean useOnlyPreferredNetwork = false;
    @JsonProperty(value="apnAuthentication")
    @JsonPropertyDescription(value="APN. APN_ Authentication. APN_ Authentication_ Code\r\nurn:x-oca:ocpp:uid:1:568828\r\nAuthentication method.\r\n")
    @NotNull
    private APNAuthenticationEnum apnAuthentication;

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public APN withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="apn")
    public String getApn() {
        return this.apn;
    }

    @JsonProperty(value="apn")
    public void setApn(String apn) {
        this.apn = apn;
    }

    public APN withApn(String apn) {
        this.apn = apn;
        return this;
    }

    @JsonProperty(value="apnUserName")
    public String getApnUserName() {
        return this.apnUserName;
    }

    @JsonProperty(value="apnUserName")
    public void setApnUserName(String apnUserName) {
        this.apnUserName = apnUserName;
    }

    public APN withApnUserName(String apnUserName) {
        this.apnUserName = apnUserName;
        return this;
    }

    @JsonProperty(value="apnPassword")
    public String getApnPassword() {
        return this.apnPassword;
    }

    @JsonProperty(value="apnPassword")
    public void setApnPassword(String apnPassword) {
        this.apnPassword = apnPassword;
    }

    public APN withApnPassword(String apnPassword) {
        this.apnPassword = apnPassword;
        return this;
    }

    @JsonProperty(value="simPin")
    public Integer getSimPin() {
        return this.simPin;
    }

    @JsonProperty(value="simPin")
    public void setSimPin(Integer simPin) {
        this.simPin = simPin;
    }

    public APN withSimPin(Integer simPin) {
        this.simPin = simPin;
        return this;
    }

    @JsonProperty(value="preferredNetwork")
    public String getPreferredNetwork() {
        return this.preferredNetwork;
    }

    @JsonProperty(value="preferredNetwork")
    public void setPreferredNetwork(String preferredNetwork) {
        this.preferredNetwork = preferredNetwork;
    }

    public APN withPreferredNetwork(String preferredNetwork) {
        this.preferredNetwork = preferredNetwork;
        return this;
    }

    @JsonProperty(value="useOnlyPreferredNetwork")
    public Boolean getUseOnlyPreferredNetwork() {
        return this.useOnlyPreferredNetwork;
    }

    @JsonProperty(value="useOnlyPreferredNetwork")
    public void setUseOnlyPreferredNetwork(Boolean useOnlyPreferredNetwork) {
        this.useOnlyPreferredNetwork = useOnlyPreferredNetwork;
    }

    public APN withUseOnlyPreferredNetwork(Boolean useOnlyPreferredNetwork) {
        this.useOnlyPreferredNetwork = useOnlyPreferredNetwork;
        return this;
    }

    @JsonProperty(value="apnAuthentication")
    public APNAuthenticationEnum getApnAuthentication() {
        return this.apnAuthentication;
    }

    @JsonProperty(value="apnAuthentication")
    public void setApnAuthentication(APNAuthenticationEnum apnAuthentication) {
        this.apnAuthentication = apnAuthentication;
    }

    public APN withApnAuthentication(APNAuthenticationEnum apnAuthentication) {
        this.apnAuthentication = apnAuthentication;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(APN.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("apn");
        sb.append('=');
        sb.append(this.apn == null ? "<null>" : this.apn);
        sb.append(',');
        sb.append("apnUserName");
        sb.append('=');
        sb.append(this.apnUserName == null ? "<null>" : this.apnUserName);
        sb.append(',');
        sb.append("apnPassword");
        sb.append('=');
        sb.append(this.apnPassword == null ? "<null>" : this.apnPassword);
        sb.append(',');
        sb.append("simPin");
        sb.append('=');
        sb.append(this.simPin == null ? "<null>" : this.simPin);
        sb.append(',');
        sb.append("preferredNetwork");
        sb.append('=');
        sb.append(this.preferredNetwork == null ? "<null>" : this.preferredNetwork);
        sb.append(',');
        sb.append("useOnlyPreferredNetwork");
        sb.append('=');
        sb.append(this.useOnlyPreferredNetwork == null ? "<null>" : this.useOnlyPreferredNetwork);
        sb.append(',');
        sb.append("apnAuthentication");
        sb.append('=');
        sb.append(this.apnAuthentication == null ? "<null>" : this.apnAuthentication);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.preferredNetwork == null ? 0 : this.preferredNetwork.hashCode());
        result = result * 31 + (this.apnUserName == null ? 0 : this.apnUserName.hashCode());
        result = result * 31 + (this.apnAuthentication == null ? 0 : this.apnAuthentication.hashCode());
        result = result * 31 + (this.useOnlyPreferredNetwork == null ? 0 : this.useOnlyPreferredNetwork.hashCode());
        result = result * 31 + (this.simPin == null ? 0 : this.simPin.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.apn == null ? 0 : this.apn.hashCode());
        result = result * 31 + (this.apnPassword == null ? 0 : this.apnPassword.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof APN)) {
            return false;
        }
        APN rhs = (APN)other;
        return (this.preferredNetwork == rhs.preferredNetwork || this.preferredNetwork != null && this.preferredNetwork.equals(rhs.preferredNetwork)) && (this.apnUserName == rhs.apnUserName || this.apnUserName != null && this.apnUserName.equals(rhs.apnUserName)) && (this.apnAuthentication == rhs.apnAuthentication || this.apnAuthentication != null && this.apnAuthentication.equals((Object)rhs.apnAuthentication)) && (this.useOnlyPreferredNetwork == rhs.useOnlyPreferredNetwork || this.useOnlyPreferredNetwork != null && this.useOnlyPreferredNetwork.equals(rhs.useOnlyPreferredNetwork)) && (this.simPin == rhs.simPin || this.simPin != null && this.simPin.equals(rhs.simPin)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.apn == rhs.apn || this.apn != null && this.apn.equals(rhs.apn)) && (this.apnPassword == rhs.apnPassword || this.apnPassword != null && this.apnPassword.equals(rhs.apnPassword));
    }
}

