/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.idsg.ocpp.jaxb;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class JodaDateTimeConverter
extends XmlAdapter<String, DateTime> {
    private static final DateTimeFormatter formatter = JodaDateTimeConverter.dateTimeParser();

    public DateTime unmarshal(String v) throws Exception {
        if (JodaDateTimeConverter.isNullOrEmpty(v)) {
            return null;
        }
        return DateTime.parse((String)v, (DateTimeFormatter)formatter);
    }

    public String marshal(DateTime v) throws Exception {
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private static DateTimeFormatter dateTimeParser() {
        return new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral('T').append(JodaDateTimeConverter.hourElement()).append(JodaDateTimeConverter.minuteElement()).append(JodaDateTimeConverter.secondElement()).appendOptional(JodaDateTimeConverter.fractionElement().getParser()).appendOptional(JodaDateTimeConverter.offsetElement().getParser()).toFormatter();
    }

    private static DateTimeFormatter hourElement() {
        return new DateTimeFormatterBuilder().appendHourOfDay(2).toFormatter();
    }

    private static DateTimeFormatter minuteElement() {
        return new DateTimeFormatterBuilder().appendLiteral(':').appendMinuteOfHour(2).toFormatter();
    }

    private static DateTimeFormatter secondElement() {
        return new DateTimeFormatterBuilder().appendLiteral(':').appendSecondOfMinute(2).toFormatter();
    }

    private static DateTimeFormatter fractionElement() {
        return new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(3, 9).toFormatter();
    }

    private static DateTimeFormatter offsetElement() {
        return new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
    }
}

