/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.type;

import android.support.annotation.CallSuper;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.util.SparseBooleanArray;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.adapter.StepAdapter;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class AbstractStepperType {
    public static final int DOTS = 1;
    public static final int PROGRESS_BAR = 2;
    public static final int TABS = 3;
    public static final int NONE = 4;
    final StepperLayout mStepperLayout;
    final SparseBooleanArray mStepErrors = new SparseBooleanArray();

    public AbstractStepperType(StepperLayout stepperLayout) {
        this.mStepperLayout = stepperLayout;
    }

    public abstract void onStepSelected(int var1, boolean var2);

    public void setErrorFlag(int stepPosition, boolean hasError) {
        this.mStepErrors.put(stepPosition, hasError);
    }

    public boolean getErrorAtPosition(int stepPosition) {
        return this.mStepErrors.get(stepPosition);
    }

    @CallSuper
    public void onNewAdapter(@NonNull StepAdapter stepAdapter) {
        this.mStepErrors.clear();
    }

    @ColorInt
    protected int getSelectedColor() {
        return this.mStepperLayout.getSelectedColor();
    }

    @ColorInt
    protected int getUnselectedColor() {
        return this.mStepperLayout.getUnselectedColor();
    }
}

