/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.viewmodel;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import com.stepstone.stepper.R;

public class StepViewModel {
    public static final int NULL_DRAWABLE = -1;
    @Nullable
    private CharSequence mTitle;
    @Nullable
    private CharSequence mNextButtonLabel;
    @Nullable
    private CharSequence mBackButtonLabel;
    @DrawableRes
    private int mNextButtonEndDrawableResId;
    @DrawableRes
    private int mBackButtonStartDrawableResId;

    private StepViewModel() {
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getNextButtonLabel() {
        return this.mNextButtonLabel;
    }

    @Nullable
    public CharSequence getBackButtonLabel() {
        return this.mBackButtonLabel;
    }

    @DrawableRes
    public int getNextButtonEndDrawableResId() {
        return this.mNextButtonEndDrawableResId;
    }

    @DrawableRes
    public int getBackButtonStartDrawableResId() {
        return this.mBackButtonStartDrawableResId;
    }

    public static class Builder {
        @NonNull
        private final Context mContext;
        @Nullable
        private CharSequence mTitle;
        @Nullable
        private CharSequence mNextButtonLabel;
        @Nullable
        private CharSequence mBackButtonLabel;
        @DrawableRes
        private int mNextButtonEndDrawableResId = R.drawable.ms_ic_chevron_end;
        @DrawableRes
        private int mBackButtonStartDrawableResId = R.drawable.ms_ic_chevron_start;

        public Builder(@NonNull Context context) {
            this.mContext = context;
        }

        public Builder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getString(titleId);
            return this;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setNextButtonLabel(@StringRes int nextButtonLabelId) {
            this.mNextButtonLabel = this.mContext.getString(nextButtonLabelId);
            return this;
        }

        public Builder setNextButtonLabel(@Nullable CharSequence nextButtonLabel) {
            this.mNextButtonLabel = nextButtonLabel;
            return this;
        }

        public Builder setBackButtonLabel(@StringRes int backButtonLabelId) {
            this.mBackButtonLabel = this.mContext.getString(backButtonLabelId);
            return this;
        }

        public Builder setBackButtonLabel(@Nullable CharSequence backButtonLabel) {
            this.mBackButtonLabel = backButtonLabel;
            return this;
        }

        public Builder setNextButtonEndDrawableResId(@DrawableRes int nextButtonEndDrawableResId) {
            this.mNextButtonEndDrawableResId = nextButtonEndDrawableResId;
            return this;
        }

        public Builder setBackButtonStartDrawableResId(@DrawableRes int backButtonStartDrawableResId) {
            this.mBackButtonStartDrawableResId = backButtonStartDrawableResId;
            return this;
        }

        public StepViewModel create() {
            StepViewModel viewModel = new StepViewModel();
            viewModel.mTitle = this.mTitle;
            viewModel.mBackButtonLabel = this.mBackButtonLabel;
            viewModel.mNextButtonLabel = this.mNextButtonLabel;
            viewModel.mNextButtonEndDrawableResId = this.mNextButtonEndDrawableResId;
            viewModel.mBackButtonStartDrawableResId = this.mBackButtonStartDrawableResId;
            return viewModel;
        }
    }
}

