/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.view.ContextThemeWrapper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.stepstone.stepper.BlockingStep;
import com.stepstone.stepper.R;
import com.stepstone.stepper.Step;
import com.stepstone.stepper.VerificationError;
import com.stepstone.stepper.adapter.StepAdapter;
import com.stepstone.stepper.internal.feedback.StepperFeedbackType;
import com.stepstone.stepper.internal.feedback.StepperFeedbackTypeFactory;
import com.stepstone.stepper.internal.type.AbstractStepperType;
import com.stepstone.stepper.internal.type.StepperTypeFactory;
import com.stepstone.stepper.internal.util.AnimationUtil;
import com.stepstone.stepper.internal.util.TintUtil;
import com.stepstone.stepper.internal.widget.ColorableProgressBar;
import com.stepstone.stepper.internal.widget.DottedProgressBar;
import com.stepstone.stepper.internal.widget.RightNavigationButton;
import com.stepstone.stepper.internal.widget.TabsContainer;
import com.stepstone.stepper.viewmodel.StepViewModel;

public class StepperLayout
extends LinearLayout
implements TabsContainer.TabItemListener {
    public static final int DEFAULT_TAB_DIVIDER_WIDTH = -1;
    private ViewPager mPager;
    private Button mBackNavigationButton;
    private RightNavigationButton mNextNavigationButton;
    private RightNavigationButton mCompleteNavigationButton;
    private ViewGroup mStepNavigation;
    private DottedProgressBar mDottedProgressBar;
    private ColorableProgressBar mProgressBar;
    private TabsContainer mTabsContainer;
    private ColorStateList mBackButtonColor;
    private ColorStateList mNextButtonColor;
    private ColorStateList mCompleteButtonColor;
    @ColorInt
    private int mUnselectedColor;
    @ColorInt
    private int mSelectedColor;
    @ColorInt
    private int mErrorColor;
    @DrawableRes
    private int mBottomNavigationBackground;
    @DrawableRes
    private int mBackButtonBackground;
    @DrawableRes
    private int mNextButtonBackground;
    @DrawableRes
    private int mCompleteButtonBackground;
    private int mTabStepDividerWidth = -1;
    private String mBackButtonText;
    private String mNextButtonText;
    private String mCompleteButtonText;
    private boolean mShowBackButtonOnFirstStep;
    private boolean mShowBottomNavigation;
    private int mTypeIdentifier = 2;
    private int mFeedbackTypeMask = 1;
    private StepAdapter mStepAdapter;
    private AbstractStepperType mStepperType;
    private StepperFeedbackType mStepperFeedbackType;
    private int mCurrentStepPosition;
    private boolean mShowErrorStateEnabled;
    private boolean mShowErrorStateOnBackEnabled;
    private boolean mTabNavigationEnabled;
    private boolean mInProgress;
    @StyleRes
    private int mStepperLayoutTheme;
    @NonNull
    private StepperListener mListener = StepperListener.NULL;
    private View.OnClickListener mOnBackClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            StepperLayout.this.onBackClicked();
        }
    };
    private View.OnClickListener mOnNextClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            StepperLayout.this.onNext();
        }
    };
    private View.OnClickListener mOnCompleteClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            StepperLayout.this.onComplete();
        }
    };

    public StepperLayout(Context context) {
        this(context, null);
    }

    public StepperLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, this.isInEditMode() ? 0 : R.attr.ms_stepperStyle);
    }

    public StepperLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    public final void setOrientation(int orientation) {
        super.setOrientation(1);
    }

    public void setListener(@NonNull StepperListener listener) {
        this.mListener = listener;
    }

    public StepAdapter getAdapter() {
        return this.mStepAdapter;
    }

    public void setAdapter(@NonNull StepAdapter stepAdapter) {
        this.mStepAdapter = stepAdapter;
        this.mPager.setAdapter(stepAdapter.getPagerAdapter());
        this.mStepperType.onNewAdapter(stepAdapter);
        this.mPager.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                StepperLayout.this.mPager.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                StepperLayout.this.onUpdate(StepperLayout.this.mCurrentStepPosition, false);
            }
        });
    }

    public void setAdapter(@NonNull StepAdapter stepAdapter, @IntRange(from=0L) int currentStepPosition) {
        this.mCurrentStepPosition = currentStepPosition;
        this.setAdapter(stepAdapter);
    }

    public void setPageTransformer(@Nullable ViewPager.PageTransformer pageTransformer) {
        this.mPager.setPageTransformer(false, pageTransformer);
    }

    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public int getUnselectedColor() {
        return this.mUnselectedColor;
    }

    public int getErrorColor() {
        return this.mErrorColor;
    }

    public int getTabStepDividerWidth() {
        return this.mTabStepDividerWidth;
    }

    @Override
    @UiThread
    public void onTabClicked(int position) {
        if (this.mTabNavigationEnabled) {
            if (position > this.mCurrentStepPosition) {
                this.onNext();
            } else if (position < this.mCurrentStepPosition) {
                this.setCurrentStepPosition(position);
            }
        }
    }

    public void proceed() {
        if (this.isLastPosition(this.mCurrentStepPosition)) {
            this.onComplete();
        } else {
            this.onNext();
        }
    }

    public void onBackClicked() {
        Step step = this.findCurrentStep();
        this.updateErrorFlagWhenGoingBack();
        OnBackClickedCallback onBackClickedCallback = new OnBackClickedCallback();
        if (step instanceof BlockingStep) {
            ((BlockingStep)step).onBackClicked(onBackClickedCallback);
        } else {
            onBackClickedCallback.goToPrevStep();
        }
    }

    public void setCurrentStepPosition(int currentStepPosition) {
        int previousStepPosition = this.mCurrentStepPosition;
        if (currentStepPosition < previousStepPosition) {
            this.updateErrorFlagWhenGoingBack();
        }
        this.mCurrentStepPosition = currentStepPosition;
        this.onUpdate(currentStepPosition, true);
    }

    public int getCurrentStepPosition() {
        return this.mCurrentStepPosition;
    }

    public void setNextButtonVerificationFailed(boolean verificationFailed) {
        this.mNextNavigationButton.setVerificationFailed(verificationFailed);
    }

    public void setCompleteButtonVerificationFailed(boolean verificationFailed) {
        this.mCompleteNavigationButton.setVerificationFailed(verificationFailed);
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.mNextNavigationButton.setEnabled(enabled);
    }

    public void setCompleteButtonEnabled(boolean enabled) {
        this.mCompleteNavigationButton.setEnabled(enabled);
    }

    public void setBackButtonEnabled(boolean enabled) {
        this.mBackNavigationButton.setEnabled(enabled);
    }

    public void setShowBottomNavigation(boolean showBottomNavigation) {
        this.mStepNavigation.setVisibility(showBottomNavigation ? 0 : 8);
    }

    @Deprecated
    public void setShowErrorStateOnBack(boolean showErrorStateOnBack) {
        this.mShowErrorStateOnBackEnabled = showErrorStateOnBack;
    }

    public void setShowErrorStateOnBackEnabled(boolean showErrorStateOnBackEnabled) {
        this.mShowErrorStateOnBackEnabled = showErrorStateOnBackEnabled;
    }

    @Deprecated
    public void setShowErrorState(boolean showErrorState) {
        this.setShowErrorStateEnabled(showErrorState);
    }

    public void setShowErrorStateEnabled(boolean showErrorStateEnabled) {
        this.mShowErrorStateEnabled = showErrorStateEnabled;
    }

    public boolean isShowErrorStateEnabled() {
        return this.mShowErrorStateEnabled;
    }

    public boolean isShowErrorStateOnBackEnabled() {
        return this.mShowErrorStateOnBackEnabled;
    }

    public boolean isTabNavigationEnabled() {
        return this.mTabNavigationEnabled;
    }

    public void setTabNavigationEnabled(boolean tabNavigationEnabled) {
        this.mTabNavigationEnabled = tabNavigationEnabled;
    }

    public void updateErrorState(boolean hasError) {
        this.updateErrorFlag(hasError);
        if (this.mShowErrorStateEnabled) {
            this.invalidateCurrentPosition();
        }
    }

    public void setOffscreenPageLimit(int limit) {
        this.mPager.setOffscreenPageLimit(limit);
    }

    public void updateErrorFlag(boolean hasError) {
        this.mStepperType.setErrorFlag(this.mCurrentStepPosition, hasError);
    }

    public void showProgress(@NonNull String progressMessage) {
        if (!this.mInProgress) {
            this.mStepperFeedbackType.showProgress(progressMessage);
            this.mInProgress = true;
        }
    }

    public void hideProgress() {
        if (this.mInProgress) {
            this.mInProgress = false;
            this.mStepperFeedbackType.hideProgress();
        }
    }

    public boolean isInProgress() {
        return this.mInProgress;
    }

    public void setFeedbackType(int feedbackTypeMask) {
        this.mFeedbackTypeMask = feedbackTypeMask;
        this.mStepperFeedbackType = StepperFeedbackTypeFactory.createType(this.mFeedbackTypeMask, this);
    }

    private void init(AttributeSet attrs, @AttrRes int defStyleAttr) {
        this.initDefaultValues();
        this.extractValuesFromAttributes(attrs, defStyleAttr);
        Context context = this.getContext();
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(context, context.getTheme());
        contextThemeWrapper.setTheme(this.mStepperLayoutTheme);
        LayoutInflater.from((Context)contextThemeWrapper).inflate(R.layout.ms_stepper_layout, (ViewGroup)this, true);
        this.setOrientation(1);
        this.bindViews();
        this.mPager.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        this.initNavigation();
        this.mDottedProgressBar.setVisibility(8);
        this.mProgressBar.setVisibility(8);
        this.mTabsContainer.setVisibility(8);
        this.mStepNavigation.setVisibility(this.mShowBottomNavigation ? 0 : 8);
        this.mStepperType = StepperTypeFactory.createType(this.mTypeIdentifier, this);
        this.mStepperFeedbackType = StepperFeedbackTypeFactory.createType(this.mFeedbackTypeMask, this);
    }

    private void initNavigation() {
        if (this.mBottomNavigationBackground != 0) {
            this.mStepNavigation.setBackgroundResource(this.mBottomNavigationBackground);
        }
        this.mBackNavigationButton.setText((CharSequence)this.mBackButtonText);
        this.mNextNavigationButton.setText(this.mNextButtonText);
        this.mCompleteNavigationButton.setText(this.mCompleteButtonText);
        this.setBackgroundIfPresent(this.mBackButtonBackground, (View)this.mBackNavigationButton);
        this.setBackgroundIfPresent(this.mNextButtonBackground, (View)this.mNextNavigationButton);
        this.setBackgroundIfPresent(this.mCompleteButtonBackground, (View)this.mCompleteNavigationButton);
        this.mBackNavigationButton.setOnClickListener(this.mOnBackClickListener);
        this.mNextNavigationButton.setOnClickListener(this.mOnNextClickListener);
        this.mCompleteNavigationButton.setOnClickListener(this.mOnCompleteClickListener);
    }

    private void setCompoundDrawablesForNavigationButtons(@DrawableRes int backDrawableResId, @DrawableRes int nextDrawableResId) {
        Drawable chevronEndDrawable;
        Drawable chevronStartDrawable = backDrawableResId != -1 ? ResourcesCompat.getDrawable((Resources)this.getContext().getResources(), (int)backDrawableResId, null) : null;
        Drawable drawable2 = chevronEndDrawable = nextDrawableResId != -1 ? ResourcesCompat.getDrawable((Resources)this.getContext().getResources(), (int)nextDrawableResId, null) : null;
        if (Build.VERSION.SDK_INT >= 17) {
            this.mBackNavigationButton.setCompoundDrawablesRelativeWithIntrinsicBounds(chevronStartDrawable, null, null, null);
        } else {
            this.mBackNavigationButton.setCompoundDrawablesWithIntrinsicBounds(chevronStartDrawable, null, null, null);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.mNextNavigationButton.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, chevronEndDrawable, null);
        } else {
            this.mNextNavigationButton.setCompoundDrawablesWithIntrinsicBounds(null, null, chevronEndDrawable, null);
        }
        TintUtil.tintTextView((TextView)this.mBackNavigationButton, this.mBackButtonColor);
        TintUtil.tintTextView((TextView)this.mNextNavigationButton, this.mNextButtonColor);
        TintUtil.tintTextView((TextView)this.mCompleteNavigationButton, this.mCompleteButtonColor);
    }

    private void setBackgroundIfPresent(@DrawableRes int backgroundRes, View view) {
        if (backgroundRes != 0) {
            view.setBackgroundResource(backgroundRes);
        }
    }

    private void bindViews() {
        this.mPager = (ViewPager)this.findViewById(R.id.ms_stepPager);
        this.mBackNavigationButton = (Button)this.findViewById(R.id.ms_stepPrevButton);
        this.mNextNavigationButton = (RightNavigationButton)this.findViewById(R.id.ms_stepNextButton);
        this.mCompleteNavigationButton = (RightNavigationButton)this.findViewById(R.id.ms_stepCompleteButton);
        this.mStepNavigation = (ViewGroup)this.findViewById(R.id.ms_bottomNavigation);
        this.mDottedProgressBar = (DottedProgressBar)this.findViewById(R.id.ms_stepDottedProgressBar);
        this.mProgressBar = (ColorableProgressBar)this.findViewById(R.id.ms_stepProgressBar);
        this.mTabsContainer = (TabsContainer)this.findViewById(R.id.ms_stepTabsContainer);
    }

    private void extractValuesFromAttributes(AttributeSet attrs, @AttrRes int defStyleAttr) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.StepperLayout, defStyleAttr, 0);
            if (a.hasValue(R.styleable.StepperLayout_ms_backButtonColor)) {
                this.mBackButtonColor = a.getColorStateList(R.styleable.StepperLayout_ms_backButtonColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_nextButtonColor)) {
                this.mNextButtonColor = a.getColorStateList(R.styleable.StepperLayout_ms_nextButtonColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_completeButtonColor)) {
                this.mCompleteButtonColor = a.getColorStateList(R.styleable.StepperLayout_ms_completeButtonColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_activeStepColor)) {
                this.mSelectedColor = a.getColor(R.styleable.StepperLayout_ms_activeStepColor, this.mSelectedColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_inactiveStepColor)) {
                this.mUnselectedColor = a.getColor(R.styleable.StepperLayout_ms_inactiveStepColor, this.mUnselectedColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_errorColor)) {
                this.mErrorColor = a.getColor(R.styleable.StepperLayout_ms_errorColor, this.mErrorColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_bottomNavigationBackground)) {
                this.mBottomNavigationBackground = a.getResourceId(R.styleable.StepperLayout_ms_bottomNavigationBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_backButtonBackground)) {
                this.mBackButtonBackground = a.getResourceId(R.styleable.StepperLayout_ms_backButtonBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_nextButtonBackground)) {
                this.mNextButtonBackground = a.getResourceId(R.styleable.StepperLayout_ms_nextButtonBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_completeButtonBackground)) {
                this.mCompleteButtonBackground = a.getResourceId(R.styleable.StepperLayout_ms_completeButtonBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_backButtonText)) {
                this.mBackButtonText = a.getString(R.styleable.StepperLayout_ms_backButtonText);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_nextButtonText)) {
                this.mNextButtonText = a.getString(R.styleable.StepperLayout_ms_nextButtonText);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_completeButtonText)) {
                this.mCompleteButtonText = a.getString(R.styleable.StepperLayout_ms_completeButtonText);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_tabStepDividerWidth)) {
                this.mTabStepDividerWidth = a.getDimensionPixelOffset(R.styleable.StepperLayout_ms_tabStepDividerWidth, -1);
            }
            this.mShowBackButtonOnFirstStep = a.getBoolean(R.styleable.StepperLayout_ms_showBackButtonOnFirstStep, false);
            this.mShowBottomNavigation = a.getBoolean(R.styleable.StepperLayout_ms_showBottomNavigation, true);
            this.mShowErrorStateEnabled = a.getBoolean(R.styleable.StepperLayout_ms_showErrorState, false);
            this.mShowErrorStateEnabled = a.getBoolean(R.styleable.StepperLayout_ms_showErrorStateEnabled, this.mShowErrorStateEnabled);
            if (a.hasValue(R.styleable.StepperLayout_ms_stepperType)) {
                this.mTypeIdentifier = a.getInt(R.styleable.StepperLayout_ms_stepperType, 2);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_stepperFeedbackType)) {
                this.mFeedbackTypeMask = a.getInt(R.styleable.StepperLayout_ms_stepperFeedbackType, 1);
            }
            this.mShowErrorStateOnBackEnabled = a.getBoolean(R.styleable.StepperLayout_ms_showErrorStateOnBack, false);
            this.mShowErrorStateOnBackEnabled = a.getBoolean(R.styleable.StepperLayout_ms_showErrorStateOnBackEnabled, this.mShowErrorStateOnBackEnabled);
            this.mTabNavigationEnabled = a.getBoolean(R.styleable.StepperLayout_ms_tabNavigationEnabled, true);
            this.mStepperLayoutTheme = a.getResourceId(R.styleable.StepperLayout_ms_stepperLayoutTheme, R.style.MSDefaultStepperLayoutTheme);
            a.recycle();
        }
    }

    private void initDefaultValues() {
        this.mNextButtonColor = this.mCompleteButtonColor = ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.ms_bottomNavigationButtonTextColor);
        this.mBackButtonColor = this.mCompleteButtonColor;
        this.mSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.ms_selectedColor);
        this.mUnselectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.ms_unselectedColor);
        this.mErrorColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.ms_errorColor);
        this.mBackButtonText = this.getContext().getString(R.string.ms_back);
        this.mNextButtonText = this.getContext().getString(R.string.ms_next);
        this.mCompleteButtonText = this.getContext().getString(R.string.ms_complete);
    }

    private boolean isLastPosition(int position) {
        return position == this.mStepAdapter.getCount() - 1;
    }

    private Step findCurrentStep() {
        return this.mStepAdapter.findStep(this.mCurrentStepPosition);
    }

    private void updateErrorFlagWhenGoingBack() {
        this.updateErrorFlag(this.mShowErrorStateOnBackEnabled && this.mStepperType.getErrorAtPosition(this.mCurrentStepPosition));
    }

    @UiThread
    private void onNext() {
        Step step = this.findCurrentStep();
        if (this.verifyCurrentStep(step)) {
            this.invalidateCurrentPosition();
            return;
        }
        OnNextClickedCallback onNextClickedCallback = new OnNextClickedCallback();
        if (step instanceof BlockingStep) {
            ((BlockingStep)step).onNextClicked(onNextClickedCallback);
        } else {
            onNextClickedCallback.goToNextStep();
        }
    }

    private void invalidateCurrentPosition() {
        this.mStepperType.onStepSelected(this.mCurrentStepPosition, false);
    }

    private boolean verifyCurrentStep(Step step) {
        VerificationError verificationError = step.verifyStep();
        boolean result = false;
        if (verificationError != null) {
            this.onError(verificationError);
            result = true;
        }
        this.updateErrorFlag(result);
        return result;
    }

    private void onError(@NonNull VerificationError verificationError) {
        Step step = this.findCurrentStep();
        if (step != null) {
            step.onError(verificationError);
        }
        this.mListener.onError(verificationError);
    }

    private void onComplete() {
        Step step = this.findCurrentStep();
        if (this.verifyCurrentStep(step)) {
            this.invalidateCurrentPosition();
            return;
        }
        OnCompleteClickedCallback onCompleteClickedCallback = new OnCompleteClickedCallback();
        if (step instanceof BlockingStep) {
            ((BlockingStep)step).onCompleteClicked(onCompleteClickedCallback);
        } else {
            onCompleteClickedCallback.complete();
        }
    }

    private void onUpdate(int newStepPosition, boolean userTriggeredChange) {
        this.mPager.setCurrentItem(newStepPosition);
        boolean isLast = this.isLastPosition(newStepPosition);
        boolean isFirst = newStepPosition == 0;
        AnimationUtil.fadeViewVisibility((View)this.mNextNavigationButton, isLast ? 8 : 0, userTriggeredChange);
        AnimationUtil.fadeViewVisibility((View)this.mCompleteNavigationButton, !isLast ? 8 : 0, userTriggeredChange);
        int backButtonTargetVisibility = isFirst && !this.mShowBackButtonOnFirstStep ? 8 : 0;
        AnimationUtil.fadeViewVisibility((View)this.mBackNavigationButton, backButtonTargetVisibility, userTriggeredChange);
        StepViewModel viewModel = this.mStepAdapter.getViewModel(newStepPosition);
        this.updateBackButton(viewModel);
        if (!isLast) {
            this.updateNextButton(viewModel);
        }
        this.setCompoundDrawablesForNavigationButtons(viewModel.getBackButtonStartDrawableResId(), viewModel.getNextButtonEndDrawableResId());
        this.mStepperType.onStepSelected(newStepPosition, userTriggeredChange);
        this.mListener.onStepSelected(newStepPosition);
        Step step = this.mStepAdapter.findStep(newStepPosition);
        if (step != null) {
            step.onSelected();
        }
    }

    private void updateNextButton(@NonNull StepViewModel viewModel) {
        CharSequence nextButtonTextForStep = viewModel.getNextButtonLabel();
        if (nextButtonTextForStep == null) {
            this.mNextNavigationButton.setText(this.mNextButtonText);
        } else {
            this.mNextNavigationButton.setText(nextButtonTextForStep);
        }
    }

    private void updateBackButton(@NonNull StepViewModel viewModel) {
        CharSequence backButtonTextForStep = viewModel.getBackButtonLabel();
        if (backButtonTextForStep == null) {
            this.mBackNavigationButton.setText((CharSequence)this.mBackButtonText);
        } else {
            this.mBackNavigationButton.setText(backButtonTextForStep);
        }
    }

    public class OnBackClickedCallback
    extends AbstractOnButtonClickedCallback {
        @UiThread
        public void goToPrevStep() {
            if (StepperLayout.this.mCurrentStepPosition <= 0) {
                if (StepperLayout.this.mShowBackButtonOnFirstStep) {
                    StepperLayout.this.mListener.onReturn();
                }
                return;
            }
            StepperLayout.this.mCurrentStepPosition--;
            StepperLayout.this.onUpdate(StepperLayout.this.mCurrentStepPosition, true);
        }
    }

    public class OnCompleteClickedCallback
    extends AbstractOnButtonClickedCallback {
        @UiThread
        public void complete() {
            StepperLayout.this.invalidateCurrentPosition();
            StepperLayout.this.mListener.onCompleted((View)StepperLayout.this.mCompleteNavigationButton);
        }
    }

    public class OnNextClickedCallback
    extends AbstractOnButtonClickedCallback {
        @UiThread
        public void goToNextStep() {
            int totalStepCount = StepperLayout.this.mStepAdapter.getCount();
            if (StepperLayout.this.mCurrentStepPosition >= totalStepCount - 1) {
                return;
            }
            StepperLayout.this.mCurrentStepPosition++;
            StepperLayout.this.onUpdate(StepperLayout.this.mCurrentStepPosition, true);
        }
    }

    public abstract class AbstractOnButtonClickedCallback {
        public StepperLayout getStepperLayout() {
            return StepperLayout.this;
        }
    }

    public static interface StepperListener {
        public static final StepperListener NULL = new StepperListener(){

            @Override
            public void onCompleted(View completeButton) {
            }

            @Override
            public void onError(VerificationError verificationError) {
            }

            @Override
            public void onStepSelected(int newStepPosition) {
            }

            @Override
            public void onReturn() {
            }
        };

        public void onCompleted(View var1);

        public void onError(VerificationError var1);

        public void onStepSelected(int var1);

        public void onReturn();
    }
}

