/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.test.idling;

import android.support.annotation.Nullable;
import android.support.test.espresso.IdlingResource;
import android.support.v4.view.ViewPager;

public final class CustomViewPagerListener
implements ViewPager.OnPageChangeListener,
IdlingResource {
    private int mCurrState = 0;
    @Nullable
    private IdlingResource.ResourceCallback mCallback;
    public boolean mNeedsIdle = false;

    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
        this.mCallback = resourceCallback;
    }

    public String getName() {
        return "View pager listener";
    }

    public boolean isIdleNow() {
        if (!this.mNeedsIdle) {
            return true;
        }
        return this.mCurrState == 0;
    }

    public void onPageSelected(int position) {
        if (this.mCurrState == 0 && this.mCallback != null) {
            this.mCallback.onTransitionToIdle();
        }
    }

    public void onPageScrollStateChanged(int state) {
        this.mCurrState = state;
        if (this.mCurrState == 0 && this.mCallback != null) {
            this.mCallback.onTransitionToIdle();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }
}

