/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.StandardHandler;
import com.github.stephenc.javaisotools.iso9660.impl.FileElement;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Config;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Constants;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Element;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Factory;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660RockRidgeFactory;
import com.github.stephenc.javaisotools.iso9660.impl.LogicalSectorElement;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.iso9660.volumedescriptors.PrimaryVolumeDescriptor;
import com.github.stephenc.javaisotools.iso9660.volumedescriptors.VolumeDescriptorSetTerminator;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeConfig;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.util.HashMap;
import java.util.Stack;

public class ISO9660Handler
extends StandardHandler {
    private Stack elements = new Stack();
    private ISO9660Config config;
    private LayoutHelper helper;
    private HashMap volumeFixups;
    private ISO9660Factory factory;

    public ISO9660Handler(StreamHandler streamHandler, ISO9660RootDirectory root, ISO9660Config config, RockRidgeConfig rrConfig) throws HandlerException {
        super(streamHandler, root, config);
        this.config = config;
        this.volumeFixups = new HashMap();
        this.checkMetadataFiles();
        ISO9660RootDirectory isoRoot = (ISO9660RootDirectory)root.clone();
        this.helper = new ISO9660LayoutHelper((StreamHandler)this, isoRoot);
        this.factory = rrConfig != null ? new ISO9660RockRidgeFactory((StreamHandler)this, config, this.helper, root, isoRoot, this.volumeFixups) : new ISO9660Factory((StreamHandler)this, config, this.helper, isoRoot, this.volumeFixups);
        if (config.dirDepthRestrictedTo8()) {
            this.factory.relocateDirectories();
        }
        this.factory.applyNamingConventions();
    }

    public void startElement(Element element) throws HandlerException {
        this.elements.push(element);
        if (element instanceof ISO9660Element) {
            String id = (String)element.getId();
            this.process(id);
        } else if (element instanceof FileElement) {
            FileElement fileElement = (FileElement)element;
            this.factory.doFileFixup(fileElement.getFile());
        }
        super.startElement(element);
    }

    private void process(String id) throws HandlerException {
        if (id.equals("VDS")) {
            this.doPVD();
        } else if (id.equals("PTA")) {
            this.factory.doPT(ISO9660Constants.TYPE_L_PT);
            this.factory.doPT(ISO9660Constants.TYPE_M_PT);
        } else if (id.equals("DRA")) {
            this.factory.doDRA();
        }
    }

    private void doPVD() throws HandlerException {
        super.startElement((Element)new LogicalSectorElement("PVD"));
        PrimaryVolumeDescriptor pvd = new PrimaryVolumeDescriptor((StreamHandler)this, this.helper);
        pvd.setMetadata(this.config);
        this.volumeFixups.putAll(pvd.doPVD());
        super.endElement();
    }

    public void endElement() throws HandlerException {
        String id;
        Element element = (Element)this.elements.pop();
        if (element instanceof ISO9660Element && (id = (String)element.getId()).equals("VDS")) {
            this.doVDST();
        }
        super.endElement();
    }

    private void doVDST() throws HandlerException {
        super.startElement((Element)new LogicalSectorElement("VDST"));
        VolumeDescriptorSetTerminator vdst = new VolumeDescriptorSetTerminator((StreamHandler)this, this.helper);
        vdst.doVDST();
        super.endElement();
    }

    public void endDocument() throws HandlerException {
        this.factory.doEmptyFileFixups();
        Fixup volumeSpaceSizeFixup = (Fixup)this.volumeFixups.get("volumeSpaceSizeFixup");
        volumeSpaceSizeFixup.data((DataReference)new BothWordDataReference(this.helper.getCurrentLocation()));
        volumeSpaceSizeFixup.close();
        this.volumeFixups.remove("volumeSpaceSizeFixup");
        super.endDocument();
    }
}

