/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.impl.FileElement;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Element;
import com.github.stephenc.javaisotools.sabre.ContentHandler;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.StructureHandler;
import com.github.stephenc.javaisotools.sabre.impl.ChainingStreamHandler;
import java.util.Iterator;

public class FileHandler
extends ChainingStreamHandler {
    private ISO9660RootDirectory root;

    public FileHandler(StreamHandler streamHandler, ISO9660RootDirectory root) {
        super((StructureHandler)streamHandler, (ContentHandler)streamHandler);
        this.root = root;
    }

    public void startElement(Element element) throws HandlerException {
        if (element instanceof ISO9660Element) {
            String id = (String)element.getId();
            this.process(id);
        }
        super.startElement(element);
    }

    private void process(String id) throws HandlerException {
        if (id.equals("FCA")) {
            this.doFCA();
        }
    }

    private void doFCA() throws HandlerException {
        this.doFCADirs(this.root);
        Iterator<ISO9660Directory> it = this.root.sortedIterator();
        while (it.hasNext()) {
            ISO9660Directory dir = it.next();
            this.doFCADirs(dir);
        }
    }

    private void doFCADirs(ISO9660Directory dir) throws HandlerException {
        for (ISO9660File file : dir.getFiles()) {
            this.doFile(file);
        }
    }

    private void doFile(ISO9660File file) throws HandlerException {
        super.startElement((Element)new FileElement(file));
        this.data(file.getDataReference());
        super.endElement();
    }
}

