/*
 * Decompiled with CFR 0.152.
 */
package toothpick;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Singleton;
import toothpick.Scope;

public abstract class ScopeNode
implements Scope {
    protected final ConcurrentHashMap<Object, ScopeNode> childrenScopes = new ConcurrentHashMap();
    protected final List<ScopeNode> parentScopes = new CopyOnWriteArrayList<ScopeNode>();
    protected Object name;
    protected boolean isOpen = true;
    protected final Set<Class<? extends Annotation>> scopeAnnotationClasses = new CopyOnWriteArraySet<Class<? extends Annotation>>();

    public ScopeNode(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("A scope can't have a null name");
        }
        this.name = name;
        this.bindScopeAnnotationIfNameIsScopeAnnotation();
    }

    public Object getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Scope)) {
            return false;
        }
        ScopeNode scopeNode = (ScopeNode)o;
        return !(this.name == null ? scopeNode.name != null : !this.name.equals(scopeNode.name));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public ScopeNode getParentScope() {
        Iterator<ScopeNode> parentIterator = this.parentScopes.iterator();
        boolean hasParent = parentIterator.hasNext();
        return hasParent ? parentIterator.next() : null;
    }

    public <A extends Annotation> ScopeNode getParentScope(Class<A> scopeAnnotationClass) {
        this.checkIsAnnotationScope(scopeAnnotationClass);
        if (scopeAnnotationClass == Singleton.class) {
            return this.getRootScope();
        }
        for (ScopeNode currentScope = this; currentScope != null; currentScope = currentScope.getParentScope()) {
            if (!currentScope.isScopeAnnotationSupported(scopeAnnotationClass)) continue;
            return currentScope;
        }
        throw new IllegalStateException(String.format("There is no parent scope of %s that supports the scope scopeAnnotationClass %s", this.name, scopeAnnotationClass.getName()));
    }

    public ScopeNode getRootScope() {
        if (this.parentScopes.isEmpty()) {
            return this;
        }
        return this.parentScopes.get(this.parentScopes.size() - 1);
    }

    public Scope supportScopeAnnotation(Class<? extends Annotation> scopeAnnotationClass) {
        this.checkIsAnnotationScope(scopeAnnotationClass);
        if (scopeAnnotationClass == Singleton.class) {
            throw new IllegalArgumentException(String.format("The annotation @Singleton is already supported by root scopes. It can't be supported programmatically.", new Object[0]));
        }
        this.scopeAnnotationClasses.add(scopeAnnotationClass);
        return this;
    }

    public boolean isScopeAnnotationSupported(Class<? extends Annotation> scopeAnnotationClass) {
        if (scopeAnnotationClass == Singleton.class) {
            return this.parentScopes.isEmpty();
        }
        return this.scopeAnnotationClasses.contains(scopeAnnotationClass);
    }

    protected void reset() {
        this.scopeAnnotationClasses.clear();
        this.isOpen = true;
        this.bindScopeAnnotationIfNameIsScopeAnnotation();
    }

    Collection<ScopeNode> getChildrenScopes() {
        return this.childrenScopes.values();
    }

    ScopeNode addChild(ScopeNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Child must be non null.");
        }
        ScopeNode parentScope = child.getParentScope();
        if (parentScope == this) {
            return child;
        }
        if (parentScope != null) {
            throw new IllegalStateException(String.format("Scope %s already has a parent: %s which is not %s", child, parentScope, this));
        }
        ScopeNode scope = this.childrenScopes.putIfAbsent(child.getName(), child);
        if (scope != null) {
            return scope;
        }
        child.parentScopes.add(this);
        child.parentScopes.addAll(this.parentScopes);
        return child;
    }

    void removeChild(ScopeNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Child must be non null.");
        }
        ScopeNode parentScope = child.getParentScope();
        if (parentScope == null) {
            throw new IllegalStateException(String.format("The scope has no parent: %s", child.getName()));
        }
        if (parentScope != this) {
            throw new IllegalStateException(String.format("The scope %s has parent: different of this: %s", child.getName(), parentScope.getName(), this.getName()));
        }
        this.childrenScopes.remove(child.getName());
        child.parentScopes.clear();
    }

    void close() {
        this.isOpen = false;
    }

    List<Object> getParentScopesNames() {
        ArrayList<Object> parentScopesNames = new ArrayList<Object>();
        for (ScopeNode parentScope : this.parentScopes) {
            parentScopesNames.add(parentScope.getName());
        }
        return parentScopesNames;
    }

    private void bindScopeAnnotationIfNameIsScopeAnnotation() {
        if (this.name.getClass() == Class.class && Annotation.class.isAssignableFrom((Class)this.name) && this.isScopeAnnotationClass((Class)this.name)) {
            this.supportScopeAnnotation((Class)this.name);
        }
    }

    private void checkIsAnnotationScope(Class<? extends Annotation> scopeAnnotationClass) {
        if (!this.isScopeAnnotationClass(scopeAnnotationClass)) {
            throw new IllegalArgumentException(String.format("The annotation %s is not a scope annotation, it is not qualified by javax.inject.Scope.", scopeAnnotationClass.getName()));
        }
    }

    private boolean isScopeAnnotationClass(Class<? extends Annotation> scopeAnnotationClass) {
        return scopeAnnotationClass.isAnnotationPresent(javax.inject.Scope.class);
    }
}

