/*
 * Decompiled with CFR 0.152.
 */
package toothpick;

import javax.inject.Provider;
import toothpick.Factory;
import toothpick.Scope;
import toothpick.locators.FactoryLocator;

public class InternalProvider<T> {
    volatile T instance;
    private Factory<? extends T> factory;
    private Class<? extends T> factoryClass;
    volatile Provider<? extends T> providerInstance;
    private Factory<? extends Provider<? extends T>> providerFactory;
    private Class<? extends Provider<? extends T>> providerFactoryClass;
    private boolean isSingleton;
    private boolean isReleasable;
    private boolean isProvidingSingleton;
    private boolean isProvidingReleasable;

    InternalProvider(T instance) {
        if (instance == null) {
            throw new IllegalArgumentException("The instance can't be null.");
        }
        this.instance = instance;
        this.isSingleton = true;
    }

    InternalProvider(Provider<? extends T> providerInstance, boolean isProvidingSingleton, boolean isProvidingReleasable) {
        if (providerInstance == null) {
            throw new IllegalArgumentException("The provider can't be null.");
        }
        this.providerInstance = providerInstance;
        this.isSingleton = true;
        this.isProvidingSingleton = isProvidingSingleton;
        this.isProvidingReleasable = isProvidingSingleton && isProvidingReleasable;
    }

    InternalProvider(Factory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("The factory can't be null.");
        }
        this.factory = factory;
        this.isSingleton = factory.hasSingletonAnnotation();
        this.isReleasable = this.isSingleton && factory.hasReleasableAnnotation();
        this.isProvidingSingleton = factory.hasProvidesSingletonAnnotation();
        this.isProvidingReleasable = this.isProvidingSingleton && factory.hasProvidesReleasableAnnotation();
    }

    InternalProvider(Class<? extends T> factoryKeyClass, boolean isSingleton, boolean isReleasable) {
        if (factoryKeyClass == null) {
            throw new IllegalArgumentException("The factory class can't be null.");
        }
        this.factoryClass = factoryKeyClass;
        this.isSingleton = isSingleton;
        this.isReleasable = this.isSingleton && isReleasable;
    }

    InternalProvider(Class<? extends Provider<? extends T>> factoryKeyClass, boolean isSingleton, boolean isReleasable, boolean isProvidingSingleton, boolean isProvidingReleasable) {
        if (factoryKeyClass == null) {
            throw new IllegalArgumentException("The factory class can't be null.");
        }
        this.providerFactoryClass = factoryKeyClass;
        this.isProvidingSingleton = isProvidingSingleton;
        this.isProvidingReleasable = this.isProvidingSingleton && isProvidingReleasable;
        this.isSingleton = isSingleton;
        this.isReleasable = this.isSingleton && isReleasable;
    }

    public synchronized T get(Scope scope) {
        if (this.instance != null) {
            return this.instance;
        }
        if (this.providerInstance != null) {
            if (this.isProvidingSingleton) {
                this.instance = this.providerInstance.get();
                return this.instance;
            }
            return (T)this.providerInstance.get();
        }
        if (this.factoryClass != null && this.factory == null) {
            this.factory = FactoryLocator.getFactory(this.factoryClass);
            this.isSingleton |= this.factory.hasSingletonAnnotation();
            this.isReleasable |= this.isSingleton && this.factory.hasReleasableAnnotation();
            this.factoryClass = null;
        }
        if (this.factory != null) {
            if (this.isSingleton) {
                this.instance = this.factory.createInstance(scope);
                this.factory = null;
                return this.instance;
            }
            return (T)this.factory.createInstance(scope);
        }
        if (this.providerFactoryClass != null && this.providerFactory == null) {
            this.providerFactory = FactoryLocator.getFactory(this.providerFactoryClass);
            this.isSingleton |= this.providerFactory.hasSingletonAnnotation();
            this.isReleasable |= this.isSingleton && this.providerFactory.hasReleasableAnnotation();
            this.isProvidingSingleton |= this.providerFactory.hasProvidesSingletonAnnotation();
            this.isProvidingReleasable |= this.isProvidingSingleton && this.providerFactory.hasProvidesReleasableAnnotation();
            this.providerFactoryClass = null;
        }
        if (this.providerFactory != null) {
            if (this.isSingleton) {
                this.providerInstance = (Provider)this.providerFactory.createInstance(scope);
                this.providerFactory = null;
                if (this.isProvidingSingleton) {
                    this.instance = this.providerInstance.get();
                    return this.instance;
                }
                return (T)this.providerInstance.get();
            }
            if (this.isProvidingSingleton) {
                this.instance = ((Provider)this.providerFactory.createInstance(scope)).get();
                this.providerFactory = null;
                return this.instance;
            }
            return (T)((Provider)this.providerFactory.createInstance(scope)).get();
        }
        throw new IllegalStateException("A provider can only be used with an instance, a provider, a factory or a provider factory. Should not happen.");
    }

    boolean isReleasable() {
        return this.isReleasable || this.isProvidingReleasable;
    }

    void release() {
        if (this.isReleasable) {
            if (this.providerInstance != null) {
                this.providerInstance = null;
            } else {
                this.instance = null;
            }
        }
        if (this.isProvidingReleasable) {
            this.instance = null;
        }
    }
}

