/*
 * Decompiled with CFR 0.152.
 */
package shadow.okhttp3.internal.sse;

import java.io.IOException;
import shadow.javax.annotation.Nullable;
import shadow.okhttp3.Call;
import shadow.okhttp3.Callback;
import shadow.okhttp3.EventListener;
import shadow.okhttp3.MediaType;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;
import shadow.okhttp3.ResponseBody;
import shadow.okhttp3.internal.Util;
import shadow.okhttp3.internal.sse.ServerSentEventReader;
import shadow.okhttp3.sse.EventSource;
import shadow.okhttp3.sse.EventSourceListener;

public final class RealEventSource
implements EventSource,
ServerSentEventReader.Callback,
Callback {
    private final Request request;
    private final EventSourceListener listener;
    private Call call;

    public RealEventSource(Request request, EventSourceListener listener) {
        this.request = request;
        this.listener = listener;
    }

    public void connect(OkHttpClient client) {
        client = client.newBuilder().eventListener(EventListener.NONE).build();
        this.call = client.newCall(this.request);
        this.call.enqueue(this);
    }

    @Override
    public void onResponse(Call call, Response response) {
        this.processResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(Response response) {
        try {
            if (!response.isSuccessful()) {
                this.listener.onFailure(this, null, response);
                return;
            }
            ResponseBody body = response.body();
            MediaType contentType = body.contentType();
            if (!RealEventSource.isEventStream(contentType)) {
                this.listener.onFailure(this, new IllegalStateException("Invalid content-type: " + contentType), response);
                return;
            }
            response = response.newBuilder().body(Util.EMPTY_RESPONSE).build();
            ServerSentEventReader reader = new ServerSentEventReader(body.source(), this);
            try {
                this.listener.onOpen(this, response);
                while (reader.processNextEvent()) {
                }
            }
            catch (Exception e) {
                this.listener.onFailure(this, e, response);
                response.close();
                return;
            }
            this.listener.onClosed(this);
        }
        finally {
            response.close();
        }
    }

    private static boolean isEventStream(@Nullable MediaType contentType) {
        return contentType != null && contentType.type().equals("text") && contentType.subtype().equals("event-stream");
    }

    @Override
    public void onFailure(Call call, IOException e) {
        this.listener.onFailure(this, e, null);
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    @Override
    public void onEvent(@Nullable String id, @Nullable String type, String data) {
        this.listener.onEvent(this, id, type, data);
    }

    @Override
    public void onRetryChange(long timeMs) {
    }
}

