/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.InnerTransactionResultPair;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.OperationResult;
import org.stellar.sdk.xdr.TransactionResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionResult
implements XdrElement {
    private Int64 feeCharged;
    private TransactionResultResult result;
    private TransactionResultExt ext;

    public Int64 getFeeCharged() {
        return this.feeCharged;
    }

    public void setFeeCharged(Int64 value) {
        this.feeCharged = value;
    }

    public TransactionResultResult getResult() {
        return this.result;
    }

    public void setResult(TransactionResultResult value) {
        this.result = value;
    }

    public TransactionResultExt getExt() {
        return this.ext;
    }

    public void setExt(TransactionResultExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionResult encodedTransactionResult) throws IOException {
        Int64.encode(stream, encodedTransactionResult.feeCharged);
        TransactionResultResult.encode(stream, encodedTransactionResult.result);
        TransactionResultExt.encode(stream, encodedTransactionResult.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionResult.encode(stream, this);
    }

    public static TransactionResult decode(XdrDataInputStream stream) throws IOException {
        TransactionResult decodedTransactionResult = new TransactionResult();
        decodedTransactionResult.feeCharged = Int64.decode(stream);
        decodedTransactionResult.result = TransactionResultResult.decode(stream);
        decodedTransactionResult.ext = TransactionResultExt.decode(stream);
        return decodedTransactionResult;
    }

    public int hashCode() {
        return Objects.hashCode(this.feeCharged, this.result, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionResult)) {
            return false;
        }
        TransactionResult other = (TransactionResult)object;
        return Objects.equal(this.feeCharged, other.feeCharged) && Objects.equal(this.result, other.result) && Objects.equal(this.ext, other.ext);
    }

    public static class TransactionResultExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, TransactionResultExt encodedTransactionResultExt) throws IOException {
            stream.writeInt(encodedTransactionResultExt.getDiscriminant());
            switch (encodedTransactionResultExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            TransactionResultExt.encode(stream, this);
        }

        public static TransactionResultExt decode(XdrDataInputStream stream) throws IOException {
            TransactionResultExt decodedTransactionResultExt = new TransactionResultExt();
            Integer discriminant = stream.readInt();
            decodedTransactionResultExt.setDiscriminant(discriminant);
            switch (decodedTransactionResultExt.getDiscriminant()) {
                default: 
            }
            return decodedTransactionResultExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TransactionResultExt)) {
                return false;
            }
            TransactionResultExt other = (TransactionResultExt)object;
            return Objects.equal(this.v, other.v);
        }

        public static final class Builder {
            private Integer discriminant;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public TransactionResultExt build() {
                TransactionResultExt val = new TransactionResultExt();
                val.setDiscriminant(this.discriminant);
                return val;
            }
        }
    }

    public static class TransactionResultResult {
        TransactionResultCode code;
        private InnerTransactionResultPair innerResultPair;
        private OperationResult[] results;

        public TransactionResultCode getDiscriminant() {
            return this.code;
        }

        public void setDiscriminant(TransactionResultCode value) {
            this.code = value;
        }

        public InnerTransactionResultPair getInnerResultPair() {
            return this.innerResultPair;
        }

        public void setInnerResultPair(InnerTransactionResultPair value) {
            this.innerResultPair = value;
        }

        public OperationResult[] getResults() {
            return this.results;
        }

        public void setResults(OperationResult[] value) {
            this.results = value;
        }

        public static void encode(XdrDataOutputStream stream, TransactionResultResult encodedTransactionResultResult) throws IOException {
            stream.writeInt(encodedTransactionResultResult.getDiscriminant().getValue());
            switch (encodedTransactionResultResult.getDiscriminant()) {
                case txFEE_BUMP_INNER_SUCCESS: 
                case txFEE_BUMP_INNER_FAILED: {
                    InnerTransactionResultPair.encode(stream, encodedTransactionResultResult.innerResultPair);
                    break;
                }
                case txSUCCESS: 
                case txFAILED: {
                    int resultssize = encodedTransactionResultResult.getResults().length;
                    stream.writeInt(resultssize);
                    for (int i = 0; i < resultssize; ++i) {
                        OperationResult.encode(stream, encodedTransactionResultResult.results[i]);
                    }
                    break;
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            TransactionResultResult.encode(stream, this);
        }

        public static TransactionResultResult decode(XdrDataInputStream stream) throws IOException {
            TransactionResultResult decodedTransactionResultResult = new TransactionResultResult();
            TransactionResultCode discriminant = TransactionResultCode.decode(stream);
            decodedTransactionResultResult.setDiscriminant(discriminant);
            switch (decodedTransactionResultResult.getDiscriminant()) {
                case txFEE_BUMP_INNER_SUCCESS: 
                case txFEE_BUMP_INNER_FAILED: {
                    decodedTransactionResultResult.innerResultPair = InnerTransactionResultPair.decode(stream);
                    break;
                }
                case txSUCCESS: 
                case txFAILED: {
                    int resultssize = stream.readInt();
                    decodedTransactionResultResult.results = new OperationResult[resultssize];
                    for (int i = 0; i < resultssize; ++i) {
                        decodedTransactionResultResult.results[i] = OperationResult.decode(stream);
                    }
                    break;
                }
            }
            return decodedTransactionResultResult;
        }

        public int hashCode() {
            return Objects.hashCode(this.innerResultPair, Arrays.hashCode(this.results), this.code);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TransactionResultResult)) {
                return false;
            }
            TransactionResultResult other = (TransactionResultResult)object;
            return Objects.equal(this.innerResultPair, other.innerResultPair) && Arrays.equals(this.results, other.results) && Objects.equal(this.code, other.code);
        }

        public static final class Builder {
            private TransactionResultCode discriminant;
            private InnerTransactionResultPair innerResultPair;
            private OperationResult[] results;

            public Builder discriminant(TransactionResultCode discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder innerResultPair(InnerTransactionResultPair innerResultPair) {
                this.innerResultPair = innerResultPair;
                return this;
            }

            public Builder results(OperationResult[] results) {
                this.results = results;
                return this;
            }

            public TransactionResultResult build() {
                TransactionResultResult val = new TransactionResultResult();
                val.setDiscriminant(this.discriminant);
                val.setInnerResultPair(this.innerResultPair);
                val.setResults(this.results);
                return val;
            }
        }
    }

    public static final class Builder {
        private Int64 feeCharged;
        private TransactionResultResult result;
        private TransactionResultExt ext;

        public Builder feeCharged(Int64 feeCharged) {
            this.feeCharged = feeCharged;
            return this;
        }

        public Builder result(TransactionResultResult result) {
            this.result = result;
            return this;
        }

        public Builder ext(TransactionResultExt ext) {
            this.ext = ext;
            return this;
        }

        public TransactionResult build() {
            TransactionResult val = new TransactionResult();
            val.setFeeCharged(this.feeCharged);
            val.setResult(this.result);
            val.setExt(this.ext);
            return val;
        }
    }
}

