/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionMetaV2
implements XdrElement {
    private LedgerEntryChanges txChangesBefore;
    private OperationMeta[] operations;
    private LedgerEntryChanges txChangesAfter;

    public LedgerEntryChanges getTxChangesBefore() {
        return this.txChangesBefore;
    }

    public void setTxChangesBefore(LedgerEntryChanges value) {
        this.txChangesBefore = value;
    }

    public OperationMeta[] getOperations() {
        return this.operations;
    }

    public void setOperations(OperationMeta[] value) {
        this.operations = value;
    }

    public LedgerEntryChanges getTxChangesAfter() {
        return this.txChangesAfter;
    }

    public void setTxChangesAfter(LedgerEntryChanges value) {
        this.txChangesAfter = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionMetaV2 encodedTransactionMetaV2) throws IOException {
        LedgerEntryChanges.encode(stream, encodedTransactionMetaV2.txChangesBefore);
        int operationssize = encodedTransactionMetaV2.getOperations().length;
        stream.writeInt(operationssize);
        for (int i = 0; i < operationssize; ++i) {
            OperationMeta.encode(stream, encodedTransactionMetaV2.operations[i]);
        }
        LedgerEntryChanges.encode(stream, encodedTransactionMetaV2.txChangesAfter);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionMetaV2.encode(stream, this);
    }

    public static TransactionMetaV2 decode(XdrDataInputStream stream) throws IOException {
        TransactionMetaV2 decodedTransactionMetaV2 = new TransactionMetaV2();
        decodedTransactionMetaV2.txChangesBefore = LedgerEntryChanges.decode(stream);
        int operationssize = stream.readInt();
        decodedTransactionMetaV2.operations = new OperationMeta[operationssize];
        for (int i = 0; i < operationssize; ++i) {
            decodedTransactionMetaV2.operations[i] = OperationMeta.decode(stream);
        }
        decodedTransactionMetaV2.txChangesAfter = LedgerEntryChanges.decode(stream);
        return decodedTransactionMetaV2;
    }

    public int hashCode() {
        return Objects.hashCode(this.txChangesBefore, Arrays.hashCode(this.operations), this.txChangesAfter);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionMetaV2)) {
            return false;
        }
        TransactionMetaV2 other = (TransactionMetaV2)object;
        return Objects.equal(this.txChangesBefore, other.txChangesBefore) && Arrays.equals(this.operations, other.operations) && Objects.equal(this.txChangesAfter, other.txChangesAfter);
    }

    public static final class Builder {
        private LedgerEntryChanges txChangesBefore;
        private OperationMeta[] operations;
        private LedgerEntryChanges txChangesAfter;

        public Builder txChangesBefore(LedgerEntryChanges txChangesBefore) {
            this.txChangesBefore = txChangesBefore;
            return this;
        }

        public Builder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        public Builder txChangesAfter(LedgerEntryChanges txChangesAfter) {
            this.txChangesAfter = txChangesAfter;
            return this;
        }

        public TransactionMetaV2 build() {
            TransactionMetaV2 val = new TransactionMetaV2();
            val.setTxChangesBefore(this.txChangesBefore);
            val.setOperations(this.operations);
            val.setTxChangesAfter(this.txChangesAfter);
            return val;
        }
    }
}

