/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.SurveyMessageCommandType;
import org.stellar.sdk.xdr.TopologyResponseBody;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SurveyResponseBody
implements XdrElement {
    SurveyMessageCommandType type;
    private TopologyResponseBody topologyResponseBody;

    public SurveyMessageCommandType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(SurveyMessageCommandType value) {
        this.type = value;
    }

    public TopologyResponseBody getTopologyResponseBody() {
        return this.topologyResponseBody;
    }

    public void setTopologyResponseBody(TopologyResponseBody value) {
        this.topologyResponseBody = value;
    }

    public static void encode(XdrDataOutputStream stream, SurveyResponseBody encodedSurveyResponseBody) throws IOException {
        stream.writeInt(encodedSurveyResponseBody.getDiscriminant().getValue());
        switch (encodedSurveyResponseBody.getDiscriminant()) {
            case SURVEY_TOPOLOGY: {
                TopologyResponseBody.encode(stream, encodedSurveyResponseBody.topologyResponseBody);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SurveyResponseBody.encode(stream, this);
    }

    public static SurveyResponseBody decode(XdrDataInputStream stream) throws IOException {
        SurveyResponseBody decodedSurveyResponseBody = new SurveyResponseBody();
        SurveyMessageCommandType discriminant = SurveyMessageCommandType.decode(stream);
        decodedSurveyResponseBody.setDiscriminant(discriminant);
        switch (decodedSurveyResponseBody.getDiscriminant()) {
            case SURVEY_TOPOLOGY: {
                decodedSurveyResponseBody.topologyResponseBody = TopologyResponseBody.decode(stream);
            }
        }
        return decodedSurveyResponseBody;
    }

    public int hashCode() {
        return Objects.hashCode(this.topologyResponseBody, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SurveyResponseBody)) {
            return false;
        }
        SurveyResponseBody other = (SurveyResponseBody)object;
        return Objects.equal(this.topologyResponseBody, other.topologyResponseBody) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private SurveyMessageCommandType discriminant;
        private TopologyResponseBody topologyResponseBody;

        public Builder discriminant(SurveyMessageCommandType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder topologyResponseBody(TopologyResponseBody topologyResponseBody) {
            this.topologyResponseBody = topologyResponseBody;
            return this;
        }

        public SurveyResponseBody build() {
            SurveyResponseBody val = new SurveyResponseBody();
            val.setDiscriminant(this.discriminant);
            val.setTopologyResponseBody(this.topologyResponseBody);
            return val;
        }
    }
}

