/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.SignerKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SignerKey
implements XdrElement {
    SignerKeyType type;
    private Uint256 ed25519;
    private Uint256 preAuthTx;
    private Uint256 hashX;

    public SignerKeyType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(SignerKeyType value) {
        this.type = value;
    }

    public Uint256 getEd25519() {
        return this.ed25519;
    }

    public void setEd25519(Uint256 value) {
        this.ed25519 = value;
    }

    public Uint256 getPreAuthTx() {
        return this.preAuthTx;
    }

    public void setPreAuthTx(Uint256 value) {
        this.preAuthTx = value;
    }

    public Uint256 getHashX() {
        return this.hashX;
    }

    public void setHashX(Uint256 value) {
        this.hashX = value;
    }

    public static void encode(XdrDataOutputStream stream, SignerKey encodedSignerKey) throws IOException {
        stream.writeInt(encodedSignerKey.getDiscriminant().getValue());
        switch (encodedSignerKey.getDiscriminant()) {
            case SIGNER_KEY_TYPE_ED25519: {
                Uint256.encode(stream, encodedSignerKey.ed25519);
                break;
            }
            case SIGNER_KEY_TYPE_PRE_AUTH_TX: {
                Uint256.encode(stream, encodedSignerKey.preAuthTx);
                break;
            }
            case SIGNER_KEY_TYPE_HASH_X: {
                Uint256.encode(stream, encodedSignerKey.hashX);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SignerKey.encode(stream, this);
    }

    public static SignerKey decode(XdrDataInputStream stream) throws IOException {
        SignerKey decodedSignerKey = new SignerKey();
        SignerKeyType discriminant = SignerKeyType.decode(stream);
        decodedSignerKey.setDiscriminant(discriminant);
        switch (decodedSignerKey.getDiscriminant()) {
            case SIGNER_KEY_TYPE_ED25519: {
                decodedSignerKey.ed25519 = Uint256.decode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_PRE_AUTH_TX: {
                decodedSignerKey.preAuthTx = Uint256.decode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_HASH_X: {
                decodedSignerKey.hashX = Uint256.decode(stream);
            }
        }
        return decodedSignerKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.ed25519, this.preAuthTx, this.hashX, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignerKey)) {
            return false;
        }
        SignerKey other = (SignerKey)object;
        return Objects.equal(this.ed25519, other.ed25519) && Objects.equal(this.preAuthTx, other.preAuthTx) && Objects.equal(this.hashX, other.hashX) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private SignerKeyType discriminant;
        private Uint256 ed25519;
        private Uint256 preAuthTx;
        private Uint256 hashX;

        public Builder discriminant(SignerKeyType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder ed25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
            return this;
        }

        public Builder preAuthTx(Uint256 preAuthTx) {
            this.preAuthTx = preAuthTx;
            return this;
        }

        public Builder hashX(Uint256 hashX) {
            this.hashX = hashX;
            return this;
        }

        public SignerKey build() {
            SignerKey val = new SignerKey();
            val.setDiscriminant(this.discriminant);
            val.setEd25519(this.ed25519);
            val.setPreAuthTx(this.preAuthTx);
            val.setHashX(this.hashX);
            return val;
        }
    }
}

