/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SetTrustLineFlagsOp
implements XdrElement {
    private AccountID trustor;
    private Asset asset;
    private Uint32 clearFlags;
    private Uint32 setFlags;

    public AccountID getTrustor() {
        return this.trustor;
    }

    public void setTrustor(AccountID value) {
        this.trustor = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Uint32 getClearFlags() {
        return this.clearFlags;
    }

    public void setClearFlags(Uint32 value) {
        this.clearFlags = value;
    }

    public Uint32 getSetFlags() {
        return this.setFlags;
    }

    public void setSetFlags(Uint32 value) {
        this.setFlags = value;
    }

    public static void encode(XdrDataOutputStream stream, SetTrustLineFlagsOp encodedSetTrustLineFlagsOp) throws IOException {
        AccountID.encode(stream, encodedSetTrustLineFlagsOp.trustor);
        Asset.encode(stream, encodedSetTrustLineFlagsOp.asset);
        Uint32.encode(stream, encodedSetTrustLineFlagsOp.clearFlags);
        Uint32.encode(stream, encodedSetTrustLineFlagsOp.setFlags);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SetTrustLineFlagsOp.encode(stream, this);
    }

    public static SetTrustLineFlagsOp decode(XdrDataInputStream stream) throws IOException {
        SetTrustLineFlagsOp decodedSetTrustLineFlagsOp = new SetTrustLineFlagsOp();
        decodedSetTrustLineFlagsOp.trustor = AccountID.decode(stream);
        decodedSetTrustLineFlagsOp.asset = Asset.decode(stream);
        decodedSetTrustLineFlagsOp.clearFlags = Uint32.decode(stream);
        decodedSetTrustLineFlagsOp.setFlags = Uint32.decode(stream);
        return decodedSetTrustLineFlagsOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.trustor, this.asset, this.clearFlags, this.setFlags);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SetTrustLineFlagsOp)) {
            return false;
        }
        SetTrustLineFlagsOp other = (SetTrustLineFlagsOp)object;
        return Objects.equal(this.trustor, other.trustor) && Objects.equal(this.asset, other.asset) && Objects.equal(this.clearFlags, other.clearFlags) && Objects.equal(this.setFlags, other.setFlags);
    }

    public static final class Builder {
        private AccountID trustor;
        private Asset asset;
        private Uint32 clearFlags;
        private Uint32 setFlags;

        public Builder trustor(AccountID trustor) {
            this.trustor = trustor;
            return this;
        }

        public Builder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        public Builder clearFlags(Uint32 clearFlags) {
            this.clearFlags = clearFlags;
            return this;
        }

        public Builder setFlags(Uint32 setFlags) {
            this.setFlags = setFlags;
            return this;
        }

        public SetTrustLineFlagsOp build() {
            SetTrustLineFlagsOp val = new SetTrustLineFlagsOp();
            val.setTrustor(this.trustor);
            val.setAsset(this.asset);
            val.setClearFlags(this.clearFlags);
            val.setSetFlags(this.setFlags);
            return val;
        }
    }
}

