/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SCPQuorumSet
implements XdrElement {
    private Uint32 threshold;
    private NodeID[] validators;
    private SCPQuorumSet[] innerSets;

    public Uint32 getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Uint32 value) {
        this.threshold = value;
    }

    public NodeID[] getValidators() {
        return this.validators;
    }

    public void setValidators(NodeID[] value) {
        this.validators = value;
    }

    public SCPQuorumSet[] getInnerSets() {
        return this.innerSets;
    }

    public void setInnerSets(SCPQuorumSet[] value) {
        this.innerSets = value;
    }

    public static void encode(XdrDataOutputStream stream, SCPQuorumSet encodedSCPQuorumSet) throws IOException {
        Uint32.encode(stream, encodedSCPQuorumSet.threshold);
        int validatorssize = encodedSCPQuorumSet.getValidators().length;
        stream.writeInt(validatorssize);
        for (int i = 0; i < validatorssize; ++i) {
            NodeID.encode(stream, encodedSCPQuorumSet.validators[i]);
        }
        int innerSetssize = encodedSCPQuorumSet.getInnerSets().length;
        stream.writeInt(innerSetssize);
        for (int i = 0; i < innerSetssize; ++i) {
            SCPQuorumSet.encode(stream, encodedSCPQuorumSet.innerSets[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCPQuorumSet.encode(stream, this);
    }

    public static SCPQuorumSet decode(XdrDataInputStream stream) throws IOException {
        SCPQuorumSet decodedSCPQuorumSet = new SCPQuorumSet();
        decodedSCPQuorumSet.threshold = Uint32.decode(stream);
        int validatorssize = stream.readInt();
        decodedSCPQuorumSet.validators = new NodeID[validatorssize];
        for (int i = 0; i < validatorssize; ++i) {
            decodedSCPQuorumSet.validators[i] = NodeID.decode(stream);
        }
        int innerSetssize = stream.readInt();
        decodedSCPQuorumSet.innerSets = new SCPQuorumSet[innerSetssize];
        for (int i = 0; i < innerSetssize; ++i) {
            decodedSCPQuorumSet.innerSets[i] = SCPQuorumSet.decode(stream);
        }
        return decodedSCPQuorumSet;
    }

    public int hashCode() {
        return Objects.hashCode(this.threshold, Arrays.hashCode(this.validators), Arrays.hashCode(this.innerSets));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCPQuorumSet)) {
            return false;
        }
        SCPQuorumSet other = (SCPQuorumSet)object;
        return Objects.equal(this.threshold, other.threshold) && Arrays.equals(this.validators, other.validators) && Arrays.equals(this.innerSets, other.innerSets);
    }

    public static final class Builder {
        private Uint32 threshold;
        private NodeID[] validators;
        private SCPQuorumSet[] innerSets;

        public Builder threshold(Uint32 threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder validators(NodeID[] validators) {
            this.validators = validators;
            return this;
        }

        public Builder innerSets(SCPQuorumSet[] innerSets) {
            this.innerSets = innerSets;
            return this;
        }

        public SCPQuorumSet build() {
            SCPQuorumSet val = new SCPQuorumSet();
            val.setThreshold(this.threshold);
            val.setValidators(this.validators);
            val.setInnerSets(this.innerSets);
            return val;
        }
    }
}

