/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class RevokeSponsorshipOp
implements XdrElement {
    RevokeSponsorshipType type;
    private LedgerKey ledgerKey;
    private RevokeSponsorshipOpSigner signer;

    public RevokeSponsorshipType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(RevokeSponsorshipType value) {
        this.type = value;
    }

    public LedgerKey getLedgerKey() {
        return this.ledgerKey;
    }

    public void setLedgerKey(LedgerKey value) {
        this.ledgerKey = value;
    }

    public RevokeSponsorshipOpSigner getSigner() {
        return this.signer;
    }

    public void setSigner(RevokeSponsorshipOpSigner value) {
        this.signer = value;
    }

    public static void encode(XdrDataOutputStream stream, RevokeSponsorshipOp encodedRevokeSponsorshipOp) throws IOException {
        stream.writeInt(encodedRevokeSponsorshipOp.getDiscriminant().getValue());
        switch (encodedRevokeSponsorshipOp.getDiscriminant()) {
            case REVOKE_SPONSORSHIP_LEDGER_ENTRY: {
                LedgerKey.encode(stream, encodedRevokeSponsorshipOp.ledgerKey);
                break;
            }
            case REVOKE_SPONSORSHIP_SIGNER: {
                RevokeSponsorshipOpSigner.encode(stream, encodedRevokeSponsorshipOp.signer);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        RevokeSponsorshipOp.encode(stream, this);
    }

    public static RevokeSponsorshipOp decode(XdrDataInputStream stream) throws IOException {
        RevokeSponsorshipOp decodedRevokeSponsorshipOp = new RevokeSponsorshipOp();
        RevokeSponsorshipType discriminant = RevokeSponsorshipType.decode(stream);
        decodedRevokeSponsorshipOp.setDiscriminant(discriminant);
        switch (decodedRevokeSponsorshipOp.getDiscriminant()) {
            case REVOKE_SPONSORSHIP_LEDGER_ENTRY: {
                decodedRevokeSponsorshipOp.ledgerKey = LedgerKey.decode(stream);
                break;
            }
            case REVOKE_SPONSORSHIP_SIGNER: {
                decodedRevokeSponsorshipOp.signer = RevokeSponsorshipOpSigner.decode(stream);
            }
        }
        return decodedRevokeSponsorshipOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.ledgerKey, this.signer, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RevokeSponsorshipOp)) {
            return false;
        }
        RevokeSponsorshipOp other = (RevokeSponsorshipOp)object;
        return Objects.equal(this.ledgerKey, other.ledgerKey) && Objects.equal(this.signer, other.signer) && Objects.equal(this.type, other.type);
    }

    public static class RevokeSponsorshipOpSigner {
        private AccountID accountID;
        private SignerKey signerKey;

        public AccountID getAccountID() {
            return this.accountID;
        }

        public void setAccountID(AccountID value) {
            this.accountID = value;
        }

        public SignerKey getSignerKey() {
            return this.signerKey;
        }

        public void setSignerKey(SignerKey value) {
            this.signerKey = value;
        }

        public static void encode(XdrDataOutputStream stream, RevokeSponsorshipOpSigner encodedRevokeSponsorshipOpSigner) throws IOException {
            AccountID.encode(stream, encodedRevokeSponsorshipOpSigner.accountID);
            SignerKey.encode(stream, encodedRevokeSponsorshipOpSigner.signerKey);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            RevokeSponsorshipOpSigner.encode(stream, this);
        }

        public static RevokeSponsorshipOpSigner decode(XdrDataInputStream stream) throws IOException {
            RevokeSponsorshipOpSigner decodedRevokeSponsorshipOpSigner = new RevokeSponsorshipOpSigner();
            decodedRevokeSponsorshipOpSigner.accountID = AccountID.decode(stream);
            decodedRevokeSponsorshipOpSigner.signerKey = SignerKey.decode(stream);
            return decodedRevokeSponsorshipOpSigner;
        }

        public int hashCode() {
            return Objects.hashCode(this.accountID, this.signerKey);
        }

        public boolean equals(Object object) {
            if (!(object instanceof RevokeSponsorshipOpSigner)) {
                return false;
            }
            RevokeSponsorshipOpSigner other = (RevokeSponsorshipOpSigner)object;
            return Objects.equal(this.accountID, other.accountID) && Objects.equal(this.signerKey, other.signerKey);
        }

        public static final class Builder {
            private AccountID accountID;
            private SignerKey signerKey;

            public Builder accountID(AccountID accountID) {
                this.accountID = accountID;
                return this;
            }

            public Builder signerKey(SignerKey signerKey) {
                this.signerKey = signerKey;
                return this;
            }

            public RevokeSponsorshipOpSigner build() {
                RevokeSponsorshipOpSigner val = new RevokeSponsorshipOpSigner();
                val.setAccountID(this.accountID);
                val.setSignerKey(this.signerKey);
                return val;
            }
        }
    }

    public static final class Builder {
        private RevokeSponsorshipType discriminant;
        private LedgerKey ledgerKey;
        private RevokeSponsorshipOpSigner signer;

        public Builder discriminant(RevokeSponsorshipType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder ledgerKey(LedgerKey ledgerKey) {
            this.ledgerKey = ledgerKey;
            return this;
        }

        public Builder signer(RevokeSponsorshipOpSigner signer) {
            this.signer = signer;
            return this;
        }

        public RevokeSponsorshipOp build() {
            RevokeSponsorshipOp val = new RevokeSponsorshipOp();
            val.setDiscriminant(this.discriminant);
            val.setLedgerKey(this.ledgerKey);
            val.setSigner(this.signer);
            return val;
        }
    }
}

