/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class PublicKey
implements XdrElement {
    PublicKeyType type;
    private Uint256 ed25519;

    public PublicKeyType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(PublicKeyType value) {
        this.type = value;
    }

    public Uint256 getEd25519() {
        return this.ed25519;
    }

    public void setEd25519(Uint256 value) {
        this.ed25519 = value;
    }

    public static void encode(XdrDataOutputStream stream, PublicKey encodedPublicKey) throws IOException {
        stream.writeInt(encodedPublicKey.getDiscriminant().getValue());
        switch (encodedPublicKey.getDiscriminant()) {
            case PUBLIC_KEY_TYPE_ED25519: {
                Uint256.encode(stream, encodedPublicKey.ed25519);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PublicKey.encode(stream, this);
    }

    public static PublicKey decode(XdrDataInputStream stream) throws IOException {
        PublicKey decodedPublicKey = new PublicKey();
        PublicKeyType discriminant = PublicKeyType.decode(stream);
        decodedPublicKey.setDiscriminant(discriminant);
        switch (decodedPublicKey.getDiscriminant()) {
            case PUBLIC_KEY_TYPE_ED25519: {
                decodedPublicKey.ed25519 = Uint256.decode(stream);
            }
        }
        return decodedPublicKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.ed25519, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)object;
        return Objects.equal(this.ed25519, other.ed25519) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private PublicKeyType discriminant;
        private Uint256 ed25519;

        public Builder discriminant(PublicKeyType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder ed25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
            return this;
        }

        public PublicKey build() {
            PublicKey val = new PublicKey();
            val.setDiscriminant(this.discriminant);
            val.setEd25519(this.ed25519);
            return val;
        }
    }
}

